/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.jpql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.BooleanType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public final class HibernateDialectExtensions {
    public static final String FN_NAME_GROUP_CONCAT = "group_concat";
    public static final String FN_NAME_MATCHES = "matches";
    public static final String FN_NAME_I_MATCHES = "i_matches";
    public static final String FN_NAME_FULLTEXT = "fulltext_search";
    public static final String FN_INSENSITIVE_LIKE = "i_like";
    public static final String FN_INSENSITIVE_EQUALS = "i_equals";
    public static final String FN_NAME_WEEK = "week";
    public static final String FN_NAME_SUM = "s_sum";
    public static final String FN_NAME_CNT = "s_count";
    public static final String FN_NAME_MIN = "s_min";
    public static final String FN_NAME_MAX = "s_max";
    public static final String FN_NAME_AVG = "s_avg";

    private HibernateDialectExtensions() {
    }

    public static Map<String, SQLFunction> getMariaDBDialectExtensions() {
        Map<String, SQLFunction> extensions = HibernateDialectExtensions.getCommonExtensions();
        extensions.put(FN_NAME_GROUP_CONCAT, (SQLFunction)new GroupConcatFunction(FN_NAME_GROUP_CONCAT, (Type)StringType.INSTANCE));
        extensions.put(FN_NAME_MATCHES, (SQLFunction)new Regexp());
        extensions.put(FN_NAME_I_MATCHES, (SQLFunction)new InsensitiveRegexp());
        extensions.put(FN_NAME_FULLTEXT, (SQLFunction)new MatchFullTextSearch());
        extensions.put(FN_INSENSITIVE_LIKE, (SQLFunction)new LikeInsensitiveSearch());
        extensions.put(FN_INSENSITIVE_EQUALS, (SQLFunction)new EqualsInsensitiveSearch());
        return extensions;
    }

    public static Map<String, SQLFunction> getH2DialectExtensions() {
        Map<String, SQLFunction> extensions = HibernateDialectExtensions.getCommonExtensions();
        extensions.put(FN_NAME_GROUP_CONCAT, (SQLFunction)new GroupConcatFunction(FN_NAME_GROUP_CONCAT, (Type)StringType.INSTANCE));
        extensions.put(FN_NAME_MATCHES, (SQLFunction)new Regexp());
        extensions.put(FN_NAME_I_MATCHES, (SQLFunction)new InsensitiveRegexp());
        extensions.put(FN_INSENSITIVE_LIKE, (SQLFunction)new LikeInsensitiveSearch());
        extensions.put(FN_INSENSITIVE_EQUALS, (SQLFunction)new EqualsInsensitiveSearch());
        return extensions;
    }

    public static Map<String, SQLFunction> getPostgresDialectExtensions() {
        Map<String, SQLFunction> extensions = HibernateDialectExtensions.getCommonExtensions();
        extensions.put(FN_NAME_GROUP_CONCAT, (SQLFunction)new StringAggFunction(FN_NAME_GROUP_CONCAT, (Type)StringType.INSTANCE));
        extensions.put(FN_NAME_WEEK, (SQLFunction)new ExtractWeek(FN_NAME_WEEK, (Type)IntegerType.INSTANCE));
        extensions.put(FN_NAME_MATCHES, (SQLFunction)new TildeStar());
        extensions.put(FN_NAME_I_MATCHES, (SQLFunction)new InsensitiveTildeStar());
        extensions.put(FN_NAME_FULLTEXT, (SQLFunction)new TsQueryFullTextSearch());
        extensions.put(FN_INSENSITIVE_LIKE, (SQLFunction)new ILikeSearch());
        extensions.put(FN_INSENSITIVE_EQUALS, (SQLFunction)new EqualsInsensitiveSearch());
        return extensions;
    }

    private static Map<String, SQLFunction> getCommonExtensions() {
        HashMap<String, SQLFunction> extensions = new HashMap<String, SQLFunction>();
        extensions.put(FN_NAME_SUM, (SQLFunction)new StandardSQLFunction("sum"));
        extensions.put(FN_NAME_MIN, (SQLFunction)new StandardSQLFunction("min"));
        extensions.put(FN_NAME_MAX, (SQLFunction)new StandardSQLFunction("max"));
        extensions.put(FN_NAME_AVG, (SQLFunction)new StandardSQLFunction("avg", (Type)DoubleType.INSTANCE));
        extensions.put(FN_NAME_CNT, (SQLFunction)new SCountDistinctFunction());
        return extensions;
    }

    private static final class EqualsInsensitiveSearch
    extends SQLFunctionTemplate {
        public EqualsInsensitiveSearch() {
            super((Type)BooleanType.INSTANCE, "( LOWER(?1) = LOWER(?2) )");
        }
    }

    private static final class ExtractWeek
    extends StandardSQLFunction {
        ExtractWeek(String name) {
            super(name);
        }

        public ExtractWeek(String name, Type registeredType) {
            super(name, registeredType);
        }

        public final String render(Type firstArgumentType, List arguments, SessionFactoryImplementor sessionFactory) {
            return "extract(week from " + arguments.get(0) + ")";
        }
    }

    private static class GroupConcatFunction
    extends StandardSQLFunction {
        GroupConcatFunction(String name, Type registeredType) {
            super(name, registeredType);
        }

        GroupConcatFunction(String name) {
            super(name);
        }

        public final String render(Type firstArgumentType, List arguments, SessionFactoryImplementor sessionFactory) {
            if (arguments.size() == 1) {
                return super.render(firstArgumentType, arguments, sessionFactory);
            }
            try {
                String separator;
                String direction = arguments.size() >= 4 ? ((String)arguments.get(3)).replaceAll("'", "") : "asc";
                String string = separator = arguments.size() >= 5 ? ((String)arguments.get(4)).replaceAll("'", "") : ",";
                if (!"asc".equalsIgnoreCase(direction) && !"desc".equalsIgnoreCase(direction)) {
                    throw new IllegalArgumentException();
                }
                if (!"'order by'".equalsIgnoreCase((String)arguments.get(1))) {
                    throw new IllegalArgumentException();
                }
                return this.createSqlQuery(arguments, direction, separator);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("usage of custom hql group_concat : group_concat(col id, [ 'order by', col id2, ['asc|desc']]", ex);
            }
        }

        protected String createSqlQuery(List<?> arguments, String direction, String separator) {
            return "group_concat(" + arguments.get(0) + " order by " + arguments.get(2) + " " + direction + " separator '" + separator + "')";
        }
    }

    private static final class ILikeSearch
    extends SQLFunctionTemplate {
        public ILikeSearch() {
            super((Type)BooleanType.INSTANCE, "( (?1) ILIKE (?2) )");
        }
    }

    private static final class InsensitiveRegexp
    extends SQLFunctionTemplate {
        public InsensitiveRegexp() {
            super((Type)BooleanType.INSTANCE, " ( LOWER(?1) regexp LOWER(?2)) ");
        }
    }

    private static final class InsensitiveTildeStar
    extends SQLFunctionTemplate {
        public InsensitiveTildeStar() {
            super((Type)BooleanType.INSTANCE, " (?1 ~* ?2) ");
        }
    }

    private static final class LikeInsensitiveSearch
    extends SQLFunctionTemplate {
        public LikeInsensitiveSearch() {
            super((Type)BooleanType.INSTANCE, "( LOWER(?1) like (?2) )");
        }
    }

    private static final class MatchFullTextSearch
    extends SQLFunctionTemplate {
        public MatchFullTextSearch() {
            super((Type)BooleanType.INSTANCE, " (MATCH(?1) AGAINST(?2 in natural language mode) > 0) ");
        }
    }

    private static final class Regexp
    extends SQLFunctionTemplate {
        public Regexp() {
            super((Type)BooleanType.INSTANCE, " (?1 regexp ?2) ");
        }
    }

    private static class SCountDistinctFunction
    extends StandardSQLFunction {
        SCountDistinctFunction() {
            super("count", (Type)LongType.INSTANCE);
        }

        public final String render(Type firstArgumentType, List arguments, SessionFactoryImplementor sessionFactory) {
            return "count(distinct " + arguments.get(0) + " )";
        }
    }

    private static final class StringAggFunction
    extends GroupConcatFunction {
        StringAggFunction(String name) {
            super(name);
        }

        StringAggFunction(String name, Type registeredType) {
            super(name, registeredType);
        }

        @Override
        public String createSqlQuery(List<?> arguments, String direction, String separator) {
            return "string_agg(cast(" + arguments.get(0) + " as text),'" + separator + "' order by " + arguments.get(2) + " " + direction + ")";
        }
    }

    private static final class TildeStar
    extends SQLFunctionTemplate {
        public TildeStar() {
            super((Type)BooleanType.INSTANCE, " (?1 ~ ?2) ");
        }
    }

    private static final class TsQueryFullTextSearch
    extends SQLFunctionTemplate {
        public TsQueryFullTextSearch() {
            super((Type)BooleanType.INSTANCE, " (?1 @@ to_tsquery(?2))");
        }
    }
}

