/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.jpql;

import com.querydsl.jpa.hibernate.NoSessionHolder;
import com.querydsl.jpa.hibernate.SessionHolder;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FixedSessionHolders {
    public static final Logger LOGGER = LoggerFactory.getLogger(FixedSessionHolders.class);

    private FixedSessionHolders() {
    }

    public static SessionHolder defaultSessionHolder(Session session) {
        return new FixedDefaultSessionHolder(session);
    }

    public static SessionHolder statelessSessionHolder(StatelessSession session) {
        return new FixedStatelessSessionHolder(session);
    }

    public static SessionHolder noSessionHolder() {
        return NoSessionHolder.DEFAULT;
    }

    private static final class FixedDefaultSessionHolder
    implements SessionHolder {
        private final Session session;

        public FixedDefaultSessionHolder(Session session) {
            this.session = session;
        }

        public Query<?> createQuery(String queryString) {
            LOGGER.info("Query String {}", (Object)queryString);
            return this.session.createQuery(queryString);
        }

        public NativeQuery<?> createSQLQuery(String queryString) {
            return this.session.createSQLQuery(queryString);
        }
    }

    private static final class FixedStatelessSessionHolder
    implements SessionHolder {
        private final StatelessSession session;

        public FixedStatelessSessionHolder(StatelessSession session) {
            this.session = session;
        }

        public Query<?> createQuery(String queryString) {
            return this.session.createQuery(queryString);
        }

        public NativeQuery<?> createSQLQuery(String queryString) {
            return this.session.createSQLQuery(queryString);
        }
    }
}

