/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.LevelUtils;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.requirement.RequirementStatus;

public enum ExecutionStatus implements Internationalizable,
Level
{
    READY(1){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            ExecutionStatus newStatus = formerExecutionStatus == FAILURE ? FAILURE : this.needsComputation();
            return newStatus;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return READY;
        }

        @Override
        public boolean isTerminatedStatus() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    NOT_RUN(2){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_NOT_RUN#resolveStatus(...) should never have been invoked. That exception cleary results from faulty logic. If you read this message please report the issue at https://ci.squashtest.org/mantis/ Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help and happy Squash !");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return BLOCKED;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    BLOCKED(3){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return BLOCKED;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return BLOCKED;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    FAILURE(4){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return FAILURE;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return FAILURE;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.FAILURE;
        }
    }
    ,
    ERROR(5){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_ERROR#resolveStatus(...) should never have been invoked. That exception cleary results from faulty logic. If you read this message please report the issue at https://ci.squashtest.org/mantis/ Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help and happy Squash !");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return BLOCKED;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    RUNNING(6){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            ExecutionStatus newStatus = formerExecutionStatus == FAILURE ? FAILURE : (formerExecutionStatus == READY ? READY : (formerExecutionStatus == RUNNING ? this.needsComputation() : RUNNING));
            return newStatus;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return RUNNING;
        }

        @Override
        public boolean isTerminatedStatus() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    WARNING(7){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_WARNING#resolveStatus(...) should never have been invoked. That exception cleary results from faulty logic. If you read this message please report the issue at https://ci.squashtest.org/mantis/ Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help and happy Squash !");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return SUCCESS;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.SUCCESS;
        }
    }
    ,
    SUCCESS(8){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            ExecutionStatus newStatus = formerExecutionStatus == FAILURE ? FAILURE : (formerStepStatus == RUNNING && formerExecutionStatus == READY ? RUNNING : this.needsComputation());
            return newStatus;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return SUCCESS;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.SUCCESS;
        }
    }
    ,
    SETTLED(9){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return this.needsComputation();
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return SETTLED;
        }

        @Override
        public boolean canBeDisabled() {
            return true;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.SUCCESS;
        }
    }
    ,
    UNTESTABLE(10){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return this.needsComputation();
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return UNTESTABLE;
        }

        @Override
        public boolean canBeDisabled() {
            return true;
        }

        @Override
        public boolean defaultEnabled() {
            return true;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    NOT_FOUND(11){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_NOT_FOUND#resolveStatus(...) should never have been invoked. That exception cleary results from faulty logic. If you read this message please report the issue at https://ci.squashtest.org/mantis/ Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help and happy Squash !");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return UNTESTABLE;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    };

    private static final String LOG_MSG_RESOLVESTATUS_ERROR = "should never have been invoked. That exception cleary results from faulty logic. If you read this message please report the issue at https://ci.squashtest.org/mantis/ Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help and happy Squash !";
    private static final String I18N_KEY_ROOT = "execution.execution-status.";
    private static final Set<ExecutionStatus> CANONICAL_STATUSES;
    public static final Set<ExecutionStatus> TERMINAL_STATUSES;
    private static final Set<ExecutionStatus> NON_TERMINAL_STATUSES;
    public static final Set<ExecutionStatus> TA_STATUSES_ONLY;
    public static final Set<ExecutionStatus> DEFAULT_DISABLED_STATUSES;
    public static final Set<ExecutionStatus> SUCCESS_STATUSES;
    private final int level;

    static {
        CANONICAL_STATUSES = LevelUtils.filterLevelEnum(ExecutionStatus.class, ExecutionStatus::isCanonical);
        TERMINAL_STATUSES = LevelUtils.filterLevelEnum(ExecutionStatus.class, ExecutionStatus::isTerminatedStatus);
        NON_TERMINAL_STATUSES = LevelUtils.excludeFromLevelEnum(ExecutionStatus.class, ExecutionStatus::isTerminatedStatus);
        HashSet<ExecutionStatus> disabled = new HashSet<ExecutionStatus>(1);
        disabled.add(SETTLED);
        DEFAULT_DISABLED_STATUSES = Collections.unmodifiableSet(disabled);
        HashSet<ExecutionStatus> TAStatuses = new HashSet<ExecutionStatus>(4);
        TAStatuses.add(ERROR);
        TAStatuses.add(WARNING);
        TAStatuses.add(NOT_FOUND);
        TAStatuses.add(NOT_RUN);
        TA_STATUSES_ONLY = Collections.unmodifiableSet(TAStatuses);
        SUCCESS_STATUSES = LevelUtils.filterLevelEnum(ExecutionStatus.class, Conclusiveness::concludeToSuccess);
    }

    private ExecutionStatus(int level) {
        this.level = level;
    }

    public static Set<ExecutionStatus> getSuccessStatusSet() {
        return SUCCESS_STATUSES;
    }

    @Deprecated
    public boolean defaultEnabled() {
        return true;
    }

    public boolean canBeDisabled() {
        return false;
    }

    public boolean isTerminatedStatus() {
        return true;
    }

    protected ExecutionStatus isAmbiguous() {
        return null;
    }

    protected boolean isAmbiguous(ExecutionStatus status) {
        return status == null;
    }

    protected ExecutionStatus needsComputation() {
        return null;
    }

    protected boolean needsComputation(ExecutionStatus status) {
        return status == null;
    }

    protected abstract ExecutionStatus resolveStatus(ExecutionStatus var1, ExecutionStatus var2);

    public abstract boolean isCanonical();

    public abstract ExecutionStatus getCanonicalStatus();

    public abstract Conclusiveness getConclusiveness();

    public static List<ExecutionStatus> toCanonicalStatusList(List<ExecutionStatus> nonCanonical) {
        ArrayList<ExecutionStatus> canonical = new ArrayList<ExecutionStatus>();
        for (ExecutionStatus nStatus : nonCanonical) {
            canonical.add(nStatus.getCanonicalStatus());
        }
        return canonical;
    }

    public static Set<ExecutionStatus> getCanonicalStatusSet() {
        return CANONICAL_STATUSES;
    }

    public static Set<ExecutionStatus> getTerminatedStatusSet() {
        return TERMINAL_STATUSES;
    }

    public static Set<ExecutionStatus> getNonTerminatedStatusSet() {
        return NON_TERMINAL_STATUSES;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public String getI18nKey() {
        return I18N_KEY_ROOT + this.name();
    }

    public ExecutionStatus deduceNewStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        return this.getCanonicalStatus().doDeduceNewStatus(formerExecutionStatus.getCanonicalStatus(), formerStepStatus.getCanonicalStatus());
    }

    protected boolean isNoneOf(ExecutionStatus ... status) {
        ExecutionStatus[] executionStatusArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionStatus state = executionStatusArray[n2];
            if (this == state) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isOneOf(ExecutionStatus ... status) {
        return !this.isNoneOf(status);
    }

    protected ExecutionStatus doDeduceNewStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        boolean needComputation;
        ExecutionStatus deductedStatus = this.trivialDeductions(formerExecutionStatus, formerStepStatus);
        Object newStatus = !this.isAmbiguous(deductedStatus) ? deductedStatus : ((needComputation = this.trivialNeedComputation(formerExecutionStatus, formerStepStatus)) ? null : this.resolveStatus(formerExecutionStatus, formerStepStatus));
        return newStatus;
    }

    public static ExecutionStatus computeNewStatus(ExecutionStatusReport report) {
        ExecutionStatus newStatus = READY;
        if (report.getTotal() != 0) {
            if (report.has(BLOCKED)) {
                newStatus = BLOCKED;
            } else if (report.allOf(UNTESTABLE)) {
                newStatus = UNTESTABLE;
            } else if (report.allOf(SETTLED, UNTESTABLE)) {
                newStatus = SETTLED;
            } else if (report.has(FAILURE)) {
                newStatus = FAILURE;
            } else if (report.allOf(SUCCESS, UNTESTABLE, SETTLED)) {
                newStatus = SUCCESS;
            } else if (report.anyOf(SUCCESS, SETTLED, RUNNING)) {
                newStatus = RUNNING;
            }
        }
        return newStatus;
    }

    protected ExecutionStatus trivialDeductions(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        ExecutionStatus newStatus = !this.hasChanged(formerStepStatus) ? formerExecutionStatus : (this.isSetToExecutionStatus(formerExecutionStatus) ? formerExecutionStatus : (this.wontUnlockBloquedExecution(formerExecutionStatus, formerStepStatus) ? BLOCKED : this.isAmbiguous()));
        return newStatus;
    }

    protected boolean trivialNeedComputation(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        boolean isMandatory = false;
        if (this.mayUnlockBloquedExecution(formerStepStatus)) {
            isMandatory = true;
        } else if (this.couldHaveSetExecStatusAlone(formerExecutionStatus, formerStepStatus)) {
            isMandatory = true;
        } else if (this == UNTESTABLE) {
            isMandatory = true;
        }
        return isMandatory;
    }

    protected boolean hasChanged(ExecutionStatus formerStepStatus) {
        return this != formerStepStatus;
    }

    protected boolean isSetToExecutionStatus(ExecutionStatus formerExecutionStatus) {
        if (this == RUNNING) {
            return false;
        }
        return this == formerExecutionStatus;
    }

    protected boolean wontUnlockBloquedExecution(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        return formerExecutionStatus == BLOCKED && formerStepStatus != BLOCKED;
    }

    protected boolean mayUnlockBloquedExecution(ExecutionStatus formerStepStatus) {
        return this != BLOCKED && formerStepStatus == BLOCKED;
    }

    protected boolean couldHaveSetExecStatusAlone(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        return formerExecutionStatus == formerStepStatus;
    }

    public static StringComparator stringComparator() {
        return new StringComparator();
    }

    public static enum Conclusiveness implements Level
    {
        SUCCESS(1),
        FAILURE(2),
        NON_CONCLUSIVE(3);

        private final int level;

        private Conclusiveness(int level) {
            this.level = level;
        }

        public String getI18nKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        public static Conclusiveness fromExecutionStatus(ExecutionStatus executionStatus) {
            return executionStatus.getConclusiveness();
        }

        public static boolean concludeToSuccess(ExecutionStatus executionStatus) {
            return executionStatus.getConclusiveness() == SUCCESS;
        }
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            RequirementStatus status2;
            RequirementStatus status1;
            try {
                String comparableString1 = this.removeDisableString(o1);
                status1 = RequirementStatus.valueOf(comparableString1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return 1;
            }
            try {
                String comparableString2 = this.removeDisableString(o2);
                status2 = RequirementStatus.valueOf(comparableString2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            return status1.compareTo(status2);
        }

        private String removeDisableString(String o) {
            String newString = o;
            String disabled = "disabled.";
            if (o.startsWith(disabled)) {
                newString = o.substring(disabled.length());
            }
            return newString;
        }
    }

    public static enum Termination implements Level
    {
        TERMINAL(1),
        NON_TERMINAL(2);

        private final int level;

        private Termination(int level) {
            this.level = level;
        }

        public String getI18nKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        public static Termination fromExecutionStatus(ExecutionStatus executionStatus) {
            ExecutionStatus canonicalStatus = executionStatus.getCanonicalStatus();
            if (canonicalStatus.isTerminatedStatus()) {
                return TERMINAL;
            }
            return NON_TERMINAL;
        }
    }
}

