/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.testcase.Dataset;

public final class ExecutionParameterInterpolator {
    private static final String PARAM_PREFIX = "\\Q${\\E";
    private static final String PARAM_SUFFIX = "\\Q}\\E";
    private static final String PARAM_PATTERN = "\\Q${\\E([A-Za-z0-9_-]{1,255})\\Q}\\E";
    private static final String NO_PARAM = "&lt;no_value&gt;";
    private static final String KEYWORD_PARAM_PATTERN = "<([A-Za-z0-9_-]{1,255})>";

    public static CollectedParameters collectParameters(Dataset dataset) {
        if (dataset == null) {
            return CollectedParameters.empty();
        }
        HashMap<Long, Map<String, String>> parameterValuesByTestCase = new HashMap<Long, Map<String, String>>();
        dataset.getParameterValues().forEach(datasetParamValue -> {
            Long referenceTestCaseId = datasetParamValue.getParameter().getTestCase().getId();
            if (!parameterValuesByTestCase.containsKey(referenceTestCaseId)) {
                parameterValuesByTestCase.put(referenceTestCaseId, new HashMap());
            }
            String paramName = datasetParamValue.getParameter().getName();
            String paramValue = datasetParamValue.getParamValue();
            ((Map)parameterValuesByTestCase.get(referenceTestCaseId)).put(paramName, paramValue);
        });
        return new CollectedParameters(parameterValuesByTestCase);
    }

    public static String replaceParams(String source, Long referenceTestCaseId, CollectedParameters collectedParameters) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        Objects.requireNonNull(referenceTestCaseId);
        Objects.requireNonNull(collectedParameters);
        return ExecutionParameterInterpolator.doReplaceParams(source, referenceTestCaseId, collectedParameters, PARAM_PATTERN);
    }

    public static String replaceKeywordParams(String source, Long referenceTestCaseId, CollectedParameters collectedParameters) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        Objects.requireNonNull(referenceTestCaseId);
        Objects.requireNonNull(collectedParameters);
        return ExecutionParameterInterpolator.doReplaceParams(source, referenceTestCaseId, collectedParameters, KEYWORD_PARAM_PATTERN);
    }

    private static String doReplaceParams(@NotNull String source, @NotNull Long referenceTestCaseId, @NotNull CollectedParameters collectedParameters, @NotNull String paramPattern) {
        CollectedParameters collectedParameters2 = collectedParameters;
        Long l = referenceTestCaseId;
        String string = source;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)l);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$3$e2ae1e40((Object)collectedParameters2);
        StringBuilder builder = new StringBuilder(source);
        Pattern pattern = Pattern.compile(paramPattern);
        Matcher matcher = pattern.matcher(source);
        int offset = 0;
        while (matcher.find()) {
            String paramName = matcher.group(1);
            String paramValue = collectedParameters.findValue(referenceTestCaseId, paramName);
            if (paramValue == null || paramValue.isEmpty()) {
                paramValue = NO_PARAM;
            }
            int start = matcher.start();
            int end = matcher.end();
            builder.replace(start + offset, end + offset, paramValue);
            offset += paramValue.length() - (end - start);
        }
        return builder.toString();
    }

    public static final class CollectedParameters {
        private final Map<Long, Map<String, String>> parameterValuesByTestCase;

        public static CollectedParameters empty() {
            return new CollectedParameters(Collections.emptyMap());
        }

        CollectedParameters(@NotNull Map<Long, Map<String, String>> parameterValuesByTestCase) {
            this.parameterValuesByTestCase = parameterValuesByTestCase;
        }

        public String findValue(@NotNull Long referenceTestCase, @NotNull String parameterName) {
            String string = parameterName;
            Long l = referenceTestCase;
            NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)l);
            NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
            return this.parameterValuesByTestCase.getOrDefault(referenceTestCase, Collections.emptyMap()).getOrDefault(parameterName, null);
        }
    }
}

