/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.collections.ListUtils;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Type;
import org.springframework.context.MessageSource;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.execution.ExecutionParameterInterpolator;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.infolist.DenormalizedNature;
import org.squashtest.tm.domain.infolist.DenormalizedType;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.exception.NotAutomatedException;
import org.squashtest.tm.exception.execution.ExecutionHasNoRunnableStepException;
import org.squashtest.tm.exception.execution.ExecutionHasNoStepsException;
import org.squashtest.tm.exception.execution.IllegalExecutionStatusException;
import org.squashtest.tm.infrastructure.hibernate.ExecutionPersister;
import org.squashtest.tm.infrastructure.hibernate.ReadOnlyCollectionPersister;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Auditable
@Entity
@Persister(impl=ExecutionPersister.class)
@Inheritance(strategy=InheritanceType.JOINED)
public class Execution
extends BaseAuditableEntity
implements AttachmentHolder,
IssueDetector,
Identified,
HasExecutionStatus,
DenormalizedFieldHolder,
BoundEntity {
    private static final String EXECUTION_ID = "EXECUTION_ID";
    static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    private static final int EXECUTION_NAME_MAX_LENGTH = 308;
    @Id
    @Column(name="EXECUTION_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="execution_execution_id_seq")
    @SequenceGenerator(name="execution_execution_id_seq", sequenceName="execution_execution_id_seq", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus = ExecutionStatus.READY;
    @Enumerated(value=EnumType.STRING)
    protected TestCaseExecutionMode executionMode = TestCaseExecutionMode.MANUAL;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String prerequisite = "";
    @NotNull
    private String reference = "";
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="TC_DESCRIPTION")
    private String tcdescription;
    @Enumerated(value=EnumType.STRING)
    @Basic(optional=false)
    private TestCaseImportance importance = TestCaseImportance.LOW;
    @Embedded
    private DenormalizedNature nature;
    @Embedded
    private DenormalizedType type;
    @Enumerated(value=EnumType.STRING)
    @Basic(optional=false)
    @Column(name="TC_STATUS")
    private TestCaseStatus status = TestCaseStatus.WORK_IN_PROGRESS;
    @NotBlank
    @Size(max=308)
    private @NotBlank @Size(max=308) String name;
    @Column
    private String datasetLabel;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="ITEM_TEST_PLAN_EXECUTION", joinColumns={@JoinColumn(name="EXECUTION_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="ITEM_TEST_PLAN_ID", insertable=false, updatable=false)})
    private IterationTestPlanItem testPlan;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TCLN_ID", referencedColumnName="TCLN_ID")
    private TestCase referencedTestCase;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="EXECUTION_STEP_ORDER")
    @JoinTable(name="EXECUTION_EXECUTION_STEPS", joinColumns={@JoinColumn(name="EXECUTION_ID")}, inverseJoinColumns={@JoinColumn(name="EXECUTION_STEP_ID")})
    private final List<ExecutionStep> steps = new ArrayList<ExecutionStep>();
    @Formula(value="(select ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER from ITEM_TEST_PLAN_EXECUTION where ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID = EXECUTION_ID)")
    private Integer executionOrder;
    @Column(insertable=false)
    private String lastExecutedBy;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastExecutedOn;
    @OneToOne(mappedBy="execution", cascade={CascadeType.REMOVE, CascadeType.PERSIST}, optional=true)
    private AutomatedExecutionExtender automatedExecutionExtender;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ISSUE_LIST_ID")
    private IssueList issueList = new IssueList();
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="EXECUTION_ISSUES_CLOSURE", joinColumns={@JoinColumn(name="EXECUTION_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="ISSUE_ID")})
    @Persister(impl=ReadOnlyCollectionPersister.class)
    @Immutable
    private List<Issue> issues = new ArrayList<Issue>();
    @Transient
    private ExecutionParameterInterpolator.CollectedParameters collectedParameters = ExecutionParameterInterpolator.CollectedParameters.empty();

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.RUNNING);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SETTLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public Execution() {
    }

    public Execution(TestCase testCase) {
        this(testCase, null, null, null);
    }

    public Execution(TestCase testCase, Dataset dataset, MessageSource messageSource, Locale locale) {
        this.fillParameterMapPrivately(dataset);
        this.setReferencedTestCase(testCase);
        this.populateSteps(dataset, messageSource, locale);
        this.populateAttachments();
        this.setDatasetLabel(testCase, dataset);
    }

    public void accept(ExecutionVisitor executionVisitor) {
        executionVisitor.visit(this);
    }

    public List<ExecutionStep> getSteps() {
        return this.steps;
    }

    public void removeStep(long executionStepId) {
        Iterator<ExecutionStep> it = this.steps.iterator();
        while (it.hasNext()) {
            if (it.next().getId() != executionStepId) continue;
            it.remove();
            return;
        }
    }

    private void setDatasetLabel(TestCase testCase, Dataset dataset) {
        String label = testCase.getDatasets().isEmpty() ? null : (dataset == null ? "" : dataset.getName());
        this.datasetLabel = label;
    }

    private void populateAttachments() {
        for (Attachment tcAttach : this.referencedTestCase.getAllAttachments()) {
            Attachment clone = tcAttach.shallowCopy();
            this.attachmentList.addAttachment(clone);
        }
    }

    private void populateSteps(Dataset dataset, MessageSource messageSource, Locale locale) {
        for (TestStep step : this.referencedTestCase.getSteps()) {
            List<ExecutionStep> execList = step.createExecutionSteps(dataset, messageSource, locale);
            for (ExecutionStep executionStep : execList) {
                this.addStep(executionStep);
            }
        }
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public Integer getExecutionOrder() {
        return this.executionOrder;
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
    }

    private void setReferencedTestCase(TestCase testCase) {
        this.referencedTestCase = testCase;
        if (testCase.getReference() != null && !testCase.getReference().isEmpty()) {
            this.setName(String.valueOf(testCase.getReference()) + " - " + testCase.getName());
        } else {
            this.setName(testCase.getName());
        }
        this.nullSafeSetTestCaseData(testCase);
        this.setImportancePrivately(testCase.getImportance());
        this.setStatusPrivately(testCase.getStatus());
        InfoListItem natureToDenormalize = testCase.getNature();
        this.nature = new DenormalizedNature(natureToDenormalize.getLabel(), natureToDenormalize.getCode(), natureToDenormalize.getIconName());
        InfoListItem typeToDenormalize = testCase.getType();
        this.type = new DenormalizedType(typeToDenormalize.getLabel(), typeToDenormalize.getCode(), typeToDenormalize.getIconName());
    }

    private void nullSafeSetTestCaseData(TestCase testCase) {
        String pr = testCase.getPrerequisite();
        this.doSetPrerequisite(pr == null ? "" : this.valueParams(pr));
        pr = testCase.getReference();
        this.doSetReference(pr == null ? "" : pr);
        pr = testCase.getDescription();
        this.doSetTcDescription(pr == null ? "" : pr);
    }

    public void fillParameterMap(Dataset dataset) {
        this.fillParameterMapPrivately(dataset);
    }

    private void fillParameterMapPrivately(Dataset datasetParam) {
        if (datasetParam != null) {
            this.collectedParameters = ExecutionParameterInterpolator.collectParameters(datasetParam);
        }
    }

    private String valueParams(String content) {
        return ExecutionParameterInterpolator.replaceParams(content, this.referencedTestCase.getId(), this.collectedParameters);
    }

    public TestCaseExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public TestCase getReferencedTestCase() {
        return this.referencedTestCase;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(@NotNull String prerequisite) {
        String string = prerequisite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        this.doSetPrerequisite(prerequisite);
    }

    private void doSetPrerequisite(@NotNull String prerequisite) {
        String string = prerequisite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        this.prerequisite = prerequisite;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.doSetReference(reference);
    }

    private void doSetReference(String reference) {
        this.reference = reference;
    }

    public TestCaseImportance getImportance() {
        return this.importance;
    }

    public void setImportance(@NotNull TestCaseImportance importance) {
        TestCaseImportance testCaseImportance = importance;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseImportance);
        this.setImportancePrivately(importance);
    }

    private void setImportancePrivately(@NotNull TestCaseImportance importanceParam) {
        TestCaseImportance testCaseImportance = importanceParam;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseImportance);
        this.importance = importanceParam;
    }

    public DenormalizedNature getNature() {
        return this.nature;
    }

    public void setNature(@NotNull DenormalizedNature nature) {
        DenormalizedNature denormalizedNature = nature;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)denormalizedNature);
        this.nature = nature;
    }

    public DenormalizedType getType() {
        return this.type;
    }

    public void setType(@NotNull DenormalizedType type) {
        DenormalizedType denormalizedType = type;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)denormalizedType);
        this.type = type;
    }

    public TestCaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull TestCaseStatus status) {
        TestCaseStatus testCaseStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseStatus);
        this.setStatusPrivately(status);
    }

    private void setStatusPrivately(@NotNull TestCaseStatus status) {
        TestCaseStatus testCaseStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseStatus);
        this.status = status;
    }

    public String getTcdescription() {
        return this.tcdescription;
    }

    public void setTcdescription(String tcdescription) {
        this.doSetTcDescription(tcdescription);
    }

    private void doSetTcDescription(String tcDescription) {
        this.tcdescription = tcDescription;
    }

    private void addStep(@NotNull ExecutionStep step) {
        ExecutionStep executionStep = step;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)executionStep);
        this.steps.add(step);
    }

    public String getDatasetLabel() {
        return this.datasetLabel;
    }

    public ExecutionStep findFirstUnexecutedStep() {
        if (!this.getSteps().isEmpty()) {
            for (ExecutionStep step : this.getSteps()) {
                if (step.getExecutionStatus().isTerminatedStatus()) continue;
                return step;
            }
        }
        return null;
    }

    public boolean hasUnexecutedSteps() {
        return this.findFirstUnexecutedStep() != null;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    public IterationTestPlanItem getTestPlan() {
        return this.testPlan;
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.testPlan.getProject().getCampaignLibrary();
    }

    @Override
    public Project getProject() {
        return this.testPlan.getProject();
    }

    @Override
    public IssueList getIssueList() {
        return this.issueList;
    }

    public List<Issue> getIssues() {
        return ListUtils.unmodifiableList(this.issues);
    }

    @Override
    public Long getIssueListId() {
        return this.issueList.getId();
    }

    @Override
    public void detachIssue(Long id) {
        this.issueList.removeIssue(id);
    }

    public void notifyAddedTo(IterationTestPlanItem testPlan) {
        this.testPlan = testPlan;
    }

    public ExecutionStep findFirstRunnableStep() throws ExecutionHasNoStepsException, ExecutionHasNoRunnableStepException {
        if (this.steps.isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        for (ExecutionStep step : this.steps) {
            if (!step.getExecutionStatus().isNoneOf(ExecutionStatus.SUCCESS)) continue;
            return step;
        }
        throw new ExecutionHasNoRunnableStepException();
    }

    public ExecutionStep getLastStep() throws ExecutionHasNoStepsException {
        if (this.steps.isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        return this.steps.get(this.steps.size() - 1);
    }

    @Override
    public List<Long> getAllIssueListId() {
        LinkedList<Long> list = new LinkedList<Long>();
        list.add(this.issueList.getId());
        for (ExecutionStep step : this.steps) {
            list.addAll(step.getAllIssueListId());
        }
        return list;
    }

    @Override
    public BugTracker getBugTracker() {
        return this.getProject().findBugTracker();
    }

    public AutomatedExecutionExtender getAutomatedExecutionExtender() {
        return this.automatedExecutionExtender;
    }

    public void setAutomatedExecutionExtender(AutomatedExecutionExtender extender) {
        this.automatedExecutionExtender = extender;
        this.executionMode = TestCaseExecutionMode.AUTOMATED;
    }

    public boolean isAutomated() {
        return this.executionMode == TestCaseExecutionMode.AUTOMATED && this.automatedExecutionExtender != null;
    }

    private boolean checkValidNewStatus(ExecutionStatus status) {
        if (this.isAutomated()) {
            return this.automatedExecutionExtender.getLegalStatusSet().contains(status);
        }
        return this.getLegalStatusSet().contains(status);
    }

    public void setExecutionStatus(ExecutionStatus status) {
        if (!this.checkValidNewStatus(status)) {
            throw new IllegalExecutionStatusException();
        }
        this.executionStatus = status;
        IterationTestPlanItem itp = this.getTestPlan();
        if (itp != null) {
            itp.updateExecutionStatus();
        }
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        if (this.isAutomated()) {
            return this.automatedExecutionExtender.getLegalStatusSet();
        }
        return LEGAL_EXEC_STATUS;
    }

    public AutomatedTest getAutomatedTest() {
        if (this.isAutomated()) {
            return this.automatedExecutionExtender.getAutomatedTest();
        }
        throw new NotAutomatedException();
    }

    public URL getResultURL() {
        if (this.isAutomated()) {
            return this.automatedExecutionExtender.getResultURL();
        }
        throw new NotAutomatedException();
    }

    public AutomatedSuite getAutomatedSuite() {
        if (this.isAutomated()) {
            return this.automatedExecutionExtender.getAutomatedSuite();
        }
        throw new NotAutomatedException();
    }

    public String getResultSummary() {
        if (this.isAutomated()) {
            return this.automatedExecutionExtender.getResultSummary();
        }
        throw new NotAutomatedException();
    }

    @Override
    public Long getDenormalizedFieldHolderId() {
        return this.getId();
    }

    @Override
    public DenormalizedFieldHolderType getDenormalizedFieldHolderType() {
        return DenormalizedFieldHolderType.EXECUTION;
    }

    public int getStepIndex(long stepId) {
        for (ExecutionStep step : this.steps) {
            if (step.getId() != stepId) continue;
            return this.steps.indexOf(step);
        }
        return -1;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.EXECUTION;
    }

    public static ExecutionStatus computeNewStatus(ExecutionStatusReport report) {
        ExecutionStatus newStatus = ExecutionStatus.READY;
        if (report.has(ExecutionStatus.BLOCKED)) {
            newStatus = ExecutionStatus.BLOCKED;
        } else if (report.has(ExecutionStatus.FAILURE)) {
            newStatus = ExecutionStatus.FAILURE;
        } else if (report.allOf(ExecutionStatus.UNTESTABLE)) {
            newStatus = ExecutionStatus.UNTESTABLE;
        } else if (report.allOf(ExecutionStatus.SETTLED, ExecutionStatus.UNTESTABLE)) {
            newStatus = ExecutionStatus.SETTLED;
        } else if (report.allOf(ExecutionStatus.SUCCESS, ExecutionStatus.UNTESTABLE, ExecutionStatus.SETTLED)) {
            newStatus = ExecutionStatus.SUCCESS;
        } else if (report.anyOf(ExecutionStatus.SUCCESS, ExecutionStatus.SETTLED, ExecutionStatus.RUNNING)) {
            newStatus = ExecutionStatus.RUNNING;
        }
        return newStatus;
    }

    public Iteration getIteration() {
        return this.testPlan.getIteration();
    }

    public Campaign getCampaign() {
        return this.getIteration().getCampaign();
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.EXECUTION, this.getId());
    }
}

