/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.environmentvariable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OrderBy;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.security.acls.model.NotFoundException;
import org.squashtest.tm.domain.common.ordered.OrderedListHelper;
import org.squashtest.tm.domain.environmentvariable.EVInputType;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableOption;
import org.squashtest.tm.domain.helper.EntityOptionHelper;

@Entity
@DiscriminatorColumn(name="FIELD_TYPE", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="SSEV")
public class SingleSelectEnvironmentVariable
extends EnvironmentVariable {
    @ElementCollection
    @CollectionTable(name="ENVIRONMENT_VARIABLE_OPTION", joinColumns={@JoinColumn(name="EV_ID")})
    @OrderBy(value="position asc")
    @Valid
    private List<EnvironmentVariableOption> options = new ArrayList<EnvironmentVariableOption>();

    public SingleSelectEnvironmentVariable() {
        super(EVInputType.DROPDOWN_LIST);
    }

    public List<EnvironmentVariableOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<EnvironmentVariableOption> options) {
        this.options = options;
    }

    public void addOption(EnvironmentVariableOption option) {
        this.checkLabelAvailability(option.getLabel());
        this.checkValueMatchPattern(option.getLabel());
        new OrderedListHelper<EnvironmentVariableOption>(this.getOptions()).addContent(option, option.getPosition());
    }

    private void addOption(int index, String label) {
        EnvironmentVariableOption option = new EnvironmentVariableOption(label, index);
        this.addOption(option);
    }

    private void checkLabelAvailability(String label) {
        List<String> optionLabels = this.options.stream().map(EnvironmentVariableOption::getLabel).collect(Collectors.toList());
        EntityOptionHelper.checkLabelAvailability(label, optionLabels);
    }

    public void changeOptionLabel(String optionLabel, String newLabel) {
        this.checkLabelAvailability(newLabel);
        this.checkValueMatchPattern(newLabel);
        int index = this.findIndexOfLabel(optionLabel);
        this.removeOption(optionLabel);
        this.addOption(index, newLabel);
    }

    private int findIndexOfLabel(String previousLabel) {
        for (EnvironmentVariableOption option : this.options) {
            if (!previousLabel.equals(option.getLabel())) continue;
            return this.options.indexOf(option);
        }
        throw new NotFoundException(previousLabel);
    }

    public void removeOptionAndReorderList(@NotBlank String label) {
        this.removeOption(label);
        new OrderedListHelper<EnvironmentVariableOption>(this.getOptions()).reorder();
    }

    private void removeOption(@NotBlank String label) {
        Iterator<EnvironmentVariableOption> iterator = this.options.iterator();
        while (iterator.hasNext()) {
            if (!label.equals(iterator.next().getLabel())) continue;
            iterator.remove();
            return;
        }
    }

    public void moveOptions(int newIndex, List<String> labels) {
        List selectedOptions = this.options.stream().filter(option -> labels.contains(option.getLabel())).collect(Collectors.toList());
        new OrderedListHelper<EnvironmentVariableOption>(this.getOptions()).moveContent(selectedOptions, (Integer)newIndex);
    }
}

