/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.environmentvariable;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.environmentvariable.EVInputType;
import org.squashtest.tm.exception.environmentvariable.ValueDoesNotMatchesPatternException;

@Entity
@DiscriminatorColumn(name="FIELD_TYPE", discriminatorType=DiscriminatorType.STRING)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorValue(value="EV")
public class EnvironmentVariable
implements Identified {
    public static final String NAME_REGEXP = "^[A-Za-z0-9_]*$";
    @Id
    @Column(name="EV_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="environment_variable_ev_id_seq")
    @SequenceGenerator(name="environment_variable_ev_id_seq", sequenceName="environment_variable_ev_id_seq", allocationSize=1)
    protected Long id;
    @NotBlank
    @Size(min=0, max=255)
    @Pattern(regexp="^[A-Za-z0-9_]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}")
    protected @NotBlank @Size(min=0, max=255) @Pattern(regexp="^[A-Za-z0-9_]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}") String name;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(updatable=false)
    protected EVInputType inputType = EVInputType.PLAIN_TEXT;

    public EnvironmentVariable() {
    }

    public EnvironmentVariable(String name, EVInputType inputType) {
        this.name = name;
        this.inputType = inputType;
    }

    public EnvironmentVariable(EVInputType inputType) {
        this.inputType = inputType;
    }

    public void checkValueMatchPattern(String value) {
        if (!value.matches(this.inputType.pattern)) {
            throw new ValueDoesNotMatchesPatternException(value, this.inputType, "value");
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public EVInputType getInputType() {
        return this.inputType;
    }

    public void setInputType(EVInputType inputType) {
        this.inputType = inputType;
    }
}

