/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.environmentvariable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentHolderType;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;

@Entity
public class DenormalizedEnvironmentVariable {
    @Id
    @Column(name="DEV_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="denormalized_environment_variable_dev_id_seq")
    @SequenceGenerator(name="denormalized_environment_variable_dev_id_seq", sequenceName="denormalized_environment_variable_dev_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="EV_ID", nullable=true)
    private EnvironmentVariable environmentVariable;
    @NotNull
    @Column(name="HOLDER_ID")
    private Long holderId;
    @Column(name="HOLDER_TYPE")
    @Enumerated(value=EnumType.STRING)
    protected DenormalizedEnvironmentHolderType holderType;
    @NotBlank
    @Size(min=1, max=255)
    private @NotBlank @Size(min=1, max=255) String name;
    @Size(min=0, max=255)
    private @Size(min=0, max=255) String value;
    private String type;

    public DenormalizedEnvironmentVariable() {
    }

    public DenormalizedEnvironmentVariable(EnvironmentVariable environmentVariable, Long holderId, DenormalizedEnvironmentHolderType holderType, String name, String value, String type) {
        this.environmentVariable = environmentVariable;
        this.holderId = holderId;
        this.holderType = holderType;
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public Long getId() {
        return this.id;
    }

    public EnvironmentVariable getEnvironmentVariable() {
        return this.environmentVariable;
    }

    public void setEnvironmentVariable(EnvironmentVariable environmentVariable) {
        this.environmentVariable = environmentVariable;
    }

    public Long getHolderId() {
        return this.holderId;
    }

    public void setHolderId(Long holderId) {
        this.holderId = holderId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public DenormalizedEnvironmentHolderType getHolderType() {
        return this.holderType;
    }

    public void setHolderType(DenormalizedEnvironmentHolderType holderType) {
        this.holderType = holderType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

