/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.denormalizedfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OrderColumn;
import javax.validation.Valid;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.DenormalizedCustomFieldOption;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;
import org.squashtest.tm.exception.customfield.OptionAlreadyExistException;
import org.squashtest.tm.exception.customfield.StringDoesNotMatchesPatternException;

@Entity
@DiscriminatorValue(value="SSF")
public class DenormalizedSingleSelectField
extends DenormalizedFieldValue {
    @ElementCollection
    @CollectionTable(name="DENORMALIZED_FIELD_OPTION", joinColumns={@JoinColumn(name="DFV_ID")})
    @OrderColumn(name="POSITION")
    @Valid
    private List<DenormalizedCustomFieldOption> options = new ArrayList<DenormalizedCustomFieldOption>();

    public DenormalizedSingleSelectField() {
    }

    public DenormalizedSingleSelectField(CustomFieldValue customFieldValue, Long denormalizedFieldHolderId, DenormalizedFieldHolderType denormalizedFieldHolderType) {
        super(customFieldValue, denormalizedFieldHolderId, denormalizedFieldHolderType);
        SingleSelectField singleSelectField = (SingleSelectField)customFieldValue.getCustomField();
        for (CustomFieldOption option : singleSelectField.getOptions()) {
            this.addOption(option);
        }
    }

    public final void addOption(DenormalizedCustomFieldOption option) {
        this.checkLabelAvailable(option.getLabel());
        this.checkCodeAvailable(option.getCode());
        this.checkCodeMatchesPattern(option.getCode());
        this.options.add(option);
    }

    private void checkCodeMatchesPattern(String code) {
        if (!code.matches("^[A-Za-z0-9_^;]*$")) {
            throw new StringDoesNotMatchesPatternException(code, "^[A-Za-z0-9_^;]*$", "optionCode");
        }
        if (code.length() > 30 || code.length() < 1) {
            throw new WrongStringSizeException("code", 1, 30);
        }
    }

    private void checkCodeAvailable(String code) {
        if (!this.isCodeAvailable(code)) {
            throw new CodeAlreadyExistsException(null, code, CustomFieldOption.class);
        }
    }

    private void checkLabelAvailable(String label) {
        if (label.length() > 255 || label.length() < 1) {
            throw new WrongStringSizeException("label", 1, 255);
        }
        if (!this.isLabelAvailable(label)) {
            throw new OptionAlreadyExistException(label);
        }
    }

    private boolean isLabelAvailable(String newlabel) {
        return this.findIndexOfLabel(newlabel) == -1;
    }

    private boolean isCodeAvailable(String newCode) {
        return this.findIndexOfCode(newCode) == -1;
    }

    private int findIndexOfCode(String newCode) {
        for (DenormalizedCustomFieldOption option : this.options) {
            if (!newCode.equals(option.getCode())) continue;
            return this.options.indexOf(option);
        }
        return -1;
    }

    private int findIndexOfLabel(String previousLabel) {
        for (DenormalizedCustomFieldOption option : this.options) {
            if (!previousLabel.equals(option.getLabel())) continue;
            return this.options.indexOf(option);
        }
        return -1;
    }

    public List<DenormalizedCustomFieldOption> getOptions() {
        return Collections.unmodifiableList(this.options);
    }
}

