/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.denormalizedfield;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;

@Entity
@DiscriminatorValue(value="RTF")
public class DenormalizedRichValue
extends DenormalizedFieldValue {
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String largeValue;

    public DenormalizedRichValue() {
    }

    public DenormalizedRichValue(CustomFieldValue customFieldValue, Long denormalizedFieldHolderId, DenormalizedFieldHolderType denormalizedFieldHolderType) {
        this.customFieldValue = customFieldValue;
        CustomField cuf = customFieldValue.getCustomField();
        this.code = cuf.getCode();
        this.inputType = cuf.getInputType();
        this.label = cuf.getLabel();
        this.value = null;
        this.largeValue = customFieldValue.getValue();
        this.position = customFieldValue.getBinding().getPosition();
        this.renderingLocations = customFieldValue.getBinding().copyRenderingLocations();
        this.denormalizedFieldHolderId = denormalizedFieldHolderId;
        this.denormalizedFieldHolderType = denormalizedFieldHolderType;
    }

    @Override
    public void setValue(String value) {
        this.largeValue = value;
    }

    @Override
    public String getValue() {
        return this.largeValue;
    }
}

