/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.denormalizedfield;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OrderColumn;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldValueOption;
import org.squashtest.tm.domain.customfield.DenormalizedCustomFieldOption;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldVisitor;

@Entity
@DiscriminatorValue(value="MFV")
public class DenormalizedMultiSelectField
extends DenormalizedFieldValue {
    @ElementCollection
    @CollectionTable(name="DENORMALIZED_FIELD_OPTION", joinColumns={@JoinColumn(name="DFV_ID")})
    @OrderColumn(name="POSITION")
    private Set<DenormalizedCustomFieldOption> options = new HashSet<DenormalizedCustomFieldOption>();
    @ElementCollection
    @CollectionTable(name="DENORMALIZED_FIELD_VALUE_OPTION", joinColumns={@JoinColumn(name="DFV_ID")})
    @OrderColumn(name="POSITION")
    private List<CustomFieldValueOption> selectedOptions = new ArrayList<CustomFieldValueOption>();

    protected DenormalizedMultiSelectField() {
    }

    public DenormalizedMultiSelectField(CustomFieldValue customFieldValue, Long denormalizedFieldHolderId, DenormalizedFieldHolderType denormalizedFieldHolderType) {
        super(customFieldValue, denormalizedFieldHolderId, denormalizedFieldHolderType);
        this.value = null;
        RawValue rawValue = customFieldValue.asRawValue();
        rawValue.setValueFor(this);
    }

    public List<String> getValues() {
        ArrayList<String> result = new ArrayList<String>(this.selectedOptions.size());
        for (CustomFieldValueOption option : this.selectedOptions) {
            result.add(option.getLabel());
        }
        return result;
    }

    public void setValues(List<String> values) {
        this.selectedOptions.clear();
        for (String option : values) {
            this.selectedOptions.add(new CustomFieldValueOption(option));
        }
    }

    public Set<DenormalizedCustomFieldOption> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    @Override
    public void accept(DenormalizedFieldVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getValue() {
        return this.selectedOptions.isEmpty() ? "" : StringUtils.join(this.getValues(), (String)"|");
    }

    @Override
    @Deprecated
    public void setValue(String value) {
        this.setValues(Arrays.asList(value.split("\\|")));
    }
}

