/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.MetaValue;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeLibraryNode;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Table(name="CUSTOM_REPORT_LIBRARY_NODE")
public class CustomReportLibraryNode
implements CustomReportTreeLibraryNode {
    private static final String CRLN_ID = "CRLN_ID";
    @Id
    @Column(name="CRLN_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="custom_report_library_node_crln_id_seq")
    @SequenceGenerator(name="custom_report_library_node_crln_id_seq", sequenceName="custom_report_library_node_crln_id_seq", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(insertable=false, updatable=false, name="ENTITY_TYPE")
    private CustomReportTreeDefinition entityType;
    @Column(insertable=false, updatable=false, name="ENTITY_ID")
    private Long entityId;
    @Column
    @Size(max=255)
    private @Size(max=255) String name;
    @JoinTable(name="CRLN_RELATIONSHIP", joinColumns={@JoinColumn(name="DESCENDANT_ID", referencedColumnName="CRLN_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="ANCESTOR_ID", referencedColumnName="CRLN_ID", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CustomReportLibraryNode.class)
    private CustomReportTreeLibraryNode parent;
    @JoinTable(name="CRLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID", referencedColumnName="CRLN_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID", referencedColumnName="CRLN_ID")})
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=CustomReportLibraryNode.class)
    @OrderColumn(name="CONTENT_ORDER")
    private List<CustomReportTreeLibraryNode> children = new ArrayList<CustomReportTreeLibraryNode>();
    @Any(metaColumn=@Column(name="ENTITY_TYPE"), fetch=FetchType.LAZY)
    @AnyMetaDef(idType="long", metaType="string", metaValues={@MetaValue(value="REPORT", targetEntity=ReportDefinition.class), @MetaValue(value="CHART", targetEntity=ChartDefinition.class), @MetaValue(value="FOLDER", targetEntity=CustomReportFolder.class), @MetaValue(value="LIBRARY", targetEntity=CustomReportLibrary.class), @MetaValue(value="DASHBOARD", targetEntity=CustomReportDashboard.class), @MetaValue(value="CUSTOM_EXPORT", targetEntity=CustomReportCustomExport.class)})
    @JoinColumn(name="ENTITY_ID")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private CustomReportTreeEntity entity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CRL_ID")
    private CustomReportLibrary library;

    public CustomReportLibraryNode() {
    }

    public CustomReportLibraryNode(CustomReportTreeDefinition entityType, Long entityId, String name, CustomReportLibrary library) {
        this.entityType = entityType;
        this.entityId = entityId;
        this.name = name;
        this.library = library;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public CustomReportTreeLibraryNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CustomReportTreeLibraryNode parent) {
        this.parent = parent;
    }

    @Override
    public List<CustomReportTreeLibraryNode> getChildren() {
        return this.children;
    }

    @Override
    public CustomReportLibrary getLibrary() {
        return this.library;
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.library;
    }

    public void setLibrary(CustomReportLibrary library) {
        this.library = library;
    }

    @Override
    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public CustomReportTreeDefinition getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntityType(CustomReportTreeDefinition entityType) {
        this.entityType = entityType;
    }

    @Override
    public CustomReportTreeEntity getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(CustomReportTreeEntity treeEntity) {
        this.entity = treeEntity;
    }

    @Override
    public void addChild(CustomReportTreeLibraryNode treeLibraryNode) {
        if (treeLibraryNode == null) {
            throw new IllegalArgumentException("Cannot add a null child to a library node");
        }
        if (treeLibraryNode.getEntity() == null) {
            throw new IllegalArgumentException("Cannot add a library node representing a null entity");
        }
        if (!this.getEntityType().isContainer()) {
            throw new UnsupportedOperationException("This type of library node doesn't accept childs");
        }
        treeLibraryNode.isCoherentWithEntity();
        String newChildName = treeLibraryNode.getName();
        if (this.childNameAlreadyUsed(newChildName)) {
            CustomReportTreeLibraryNode node = this.getContentNodeByName(newChildName);
            throw new DuplicateNameException(node.getEntityType().getTypeName(), newChildName);
        }
        this.getChildren().add(treeLibraryNode);
    }

    @Override
    public void isCoherentWithEntity() {
        String entityName;
        String nodeName = this.getName();
        if (!nodeName.equals(entityName = this.getEntity().getName())) {
            String message = "Cannot add a library node of with name %s to represent an entity with diffrent name %s";
            throw new IllegalArgumentException(String.format(message, nodeName, entityName));
        }
    }

    @Override
    public boolean childNameAlreadyUsed(String newChildName) {
        for (TreeLibraryNode treeLibraryNode : this.children) {
            if (!treeLibraryNode.getName().equals(newChildName)) continue;
            return true;
        }
        return false;
    }

    private CustomReportTreeLibraryNode getContentNodeByName(String name) {
        for (CustomReportTreeLibraryNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void removeChild(CustomReportTreeLibraryNode treeLibraryNode) {
        this.children.remove(treeLibraryNode);
        this.children = new ArrayList<CustomReportTreeLibraryNode>(this.children);
    }

    @Override
    public boolean hasContent() {
        if (!this.getEntityType().isContainer()) {
            return false;
        }
        return !this.children.isEmpty();
    }

    @Override
    public void renameNode(String newName) {
        if (this.getEntityType().equals(CustomReportTreeDefinition.LIBRARY)) {
            throw new IllegalArgumentException("Cannot rename a library, rename the project instead");
        }
        if (this.nameAlreadyUsedBySibling(newName)) {
            throw new DuplicateNameException(newName, this.getEntityType().getTypeName());
        }
        this.setName(newName);
        this.getEntity().setName(newName);
    }

    private boolean nameAlreadyUsedBySibling(String newName) {
        List<String> siblingsNames = this.getSiblingsNames();
        return siblingsNames.contains(newName);
    }

    private List<String> getSiblingsNames() {
        List<CustomReportTreeLibraryNode> siblings = this.getSiblings();
        ArrayList<String> siblingNames = new ArrayList<String>();
        for (TreeLibraryNode treeLibraryNode : siblings) {
            siblingNames.add(treeLibraryNode.getName());
        }
        return siblingNames;
    }

    private List<CustomReportTreeLibraryNode> getSiblings() {
        CustomReportTreeLibraryNode parentNode = this.getParent();
        return parentNode.getChildren();
    }
}

