/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Auditable
public class CustomReportDashboard
extends BaseAuditableEntity
implements CustomReportTreeEntity {
    @Id
    @Column(name="CRD_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="custom_report_dashboard_crd_id_seq")
    @SequenceGenerator(name="custom_report_dashboard_crd_id_seq", sequenceName="custom_report_dashboard_crd_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Size(max=255)
    @Column
    private @NotBlank @Size(max=255) String name;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @NotNull
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dashboard", cascade={CascadeType.ALL})
    private Set<CustomReportChartBinding> chartBindings = new HashSet<CustomReportChartBinding>();
    @NotNull
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dashboard", cascade={CascadeType.ALL})
    private Set<CustomReportReportBinding> reportBindings = new HashSet<CustomReportReportBinding>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void accept(CustomReportTreeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public CustomReportTreeEntity createCopy() {
        CustomReportDashboard copy = new CustomReportDashboard();
        copy.setProject(this.getProject());
        copy.setName(this.getName());
        copy.getChartBindings().addAll(this.copyChartBindingsToAnotherDashboard(copy));
        copy.getReportBindings().addAll(this.copyReportBindingsToAnotherDashboard(copy));
        return copy;
    }

    private Set<CustomReportChartBinding> copyChartBindingsToAnotherDashboard(CustomReportDashboard target) {
        HashSet<CustomReportChartBinding> copy = new HashSet<CustomReportChartBinding>();
        for (CustomReportChartBinding chartBinding : this.chartBindings) {
            CustomReportChartBinding chartBindingCopy = chartBinding.createCopy();
            chartBindingCopy.setDashboard(target);
            copy.add(chartBindingCopy);
        }
        return copy;
    }

    private Set<CustomReportReportBinding> copyReportBindingsToAnotherDashboard(CustomReportDashboard target) {
        HashSet<CustomReportReportBinding> copy = new HashSet<CustomReportReportBinding>();
        for (CustomReportReportBinding reportBinding : this.reportBindings) {
            CustomReportReportBinding reportBindingCopy = reportBinding.createCopy();
            reportBindingCopy.setDashboard(target);
            copy.add(reportBindingCopy);
        }
        return copy;
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.getProject().getCustomReportLibrary();
    }

    public Set<CustomReportChartBinding> getChartBindings() {
        return this.chartBindings;
    }

    public void setChartBindings(Set<CustomReportChartBinding> chartBindings) {
        this.chartBindings = chartBindings;
    }

    public Set<CustomReportReportBinding> getReportBindings() {
        return this.reportBindings;
    }

    public void setReportBindings(Set<CustomReportReportBinding> reportBindings) {
        this.reportBindings = reportBindings;
    }
}

