/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldValueVisitor;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.exception.customfield.MandatoryCufException;

@Entity
@DiscriminatorValue(value="RTF")
public class RichTextValue
extends CustomFieldValue {
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String largeValue;

    @Override
    public void setValue(String value) {
        CustomField field = this.getCustomField();
        if (field != null && !field.isOptional() && StringUtils.isBlank((CharSequence)value)) {
            throw new MandatoryCufException(this);
        }
        this.largeValue = value;
    }

    @Override
    public String getValue() {
        return this.largeValue != null ? this.largeValue : "";
    }

    @Override
    public CustomFieldValue copy() {
        RichTextValue copy = new RichTextValue();
        copy.setBinding(this.getBinding());
        ((CustomFieldValue)copy).setValue(this.getValue());
        copy.setCufId(this.binding.getCustomField().getId());
        return copy;
    }

    @Override
    public void accept(CustomFieldValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public RawValue asRawValue() {
        return new RawValue(this.largeValue);
    }
}

