/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import java.text.ParseException;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.validation.constraint.HasDefaultAsRequired;

@NamedQueries(value={@NamedQuery(name="CustomField.findAllOrderedByName", query="from CustomField cf order by cf.name"), @NamedQuery(name="CustomField.countCustomFields", query="select count(*) from CustomField"), @NamedQuery(name="CustomField.findByCode", query="from CustomField where code = ?1")})
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="FIELD_TYPE", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="CF")
@HasDefaultAsRequired
public class CustomField
implements Identified {
    public static final String CODE_REGEXP = "^[A-Za-z0-9_^;]*$";
    public static final String OPTION_REGEXP = "^[A-Za-z0-9_]*$";
    public static final int MIN_CODE_SIZE = 1;
    public static final int MAX_CODE_SIZE = 30;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomField.class);
    @Id
    @Column(name="CF_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="custom_field_cf_id_seq")
    @SequenceGenerator(name="custom_field_cf_id_seq", sequenceName="custom_field_cf_id_seq", allocationSize=1)
    protected Long id;
    @NotBlank
    @Size(min=0, max=255)
    protected @NotBlank @Size(min=0, max=255) String name;
    @NotBlank
    @Size(min=0, max=255)
    protected @NotBlank @Size(min=0, max=255) String label = "";
    protected boolean optional = true;
    @Size(min=0, max=255)
    protected @Size(min=0, max=255) String defaultValue;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(updatable=false)
    protected InputType inputType = InputType.PLAIN_TEXT;
    @NotBlank
    @Size(min=1, max=30)
    @Pattern(regexp="^[A-Za-z0-9_^;]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}")
    protected @NotBlank @Size(min=1, max=30) @Pattern(regexp="^[A-Za-z0-9_^;]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}") String code = "";

    protected CustomField() {
    }

    public CustomField(@NotNull InputType inputType) {
        this.inputType = inputType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isOptional() {
        if (this.inputType == InputType.CHECKBOX) {
            return false;
        }
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        String dValue = defaultValue;
        if (this.inputType == InputType.DATE_PICKER) {
            try {
                DateUtils.parseIso8601Date((String)defaultValue);
            }
            catch (ParseException parseException) {
                dValue = "";
            }
        }
        this.defaultValue = dValue;
    }

    public Date getDefaultValueAsDate() {
        if (this.inputType == InputType.DATE_PICKER) {
            try {
                return DateUtils.parseIso8601Date((String)this.defaultValue);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void accept(CustomFieldVisitor visitor) {
        visitor.visit(this);
    }
}

