/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.common.ordered;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.common.ordered.ListIndexValidator;
import org.squashtest.tm.domain.common.ordered.Ordered;

public class OrderedListHelper<ENTITY extends Ordered> {
    private final List<ENTITY> orderedList;

    public OrderedListHelper(List<ENTITY> orderedList) {
        this.orderedList = Objects.requireNonNull(orderedList);
    }

    public void addContent(ENTITY entity) {
        this.addContent(entity, null);
    }

    public void addContent(ENTITY entity, Integer position) {
        Objects.requireNonNull(entity);
        boolean valid = new ListIndexValidator<ENTITY>(this.orderedList, position).isValid();
        if (valid) {
            this.orderedList.add(position, entity);
        } else {
            this.orderedList.add(entity);
        }
        this.reorder();
    }

    public void moveContent(Integer oldPosition, Integer newPosition) {
        Ordered entity = (Ordered)this.orderedList.get(oldPosition);
        this.moveContent(entity, newPosition);
    }

    public void moveContent(ENTITY entity, Integer newPosition) {
        this.moveContent(Collections.singletonList(entity), newPosition);
    }

    public void moveContent(List<ENTITY> entities, Integer newPosition) {
        Objects.requireNonNull(entities);
        if (!entities.isEmpty()) {
            this.doMoveContent(entities, newPosition);
        }
    }

    private void doMoveContent(List<ENTITY> entities, Integer newPosition) {
        this.checkMovedEntitiesAreInList(entities);
        this.orderedList.removeAll(entities);
        Integer validPosition = new ListIndexValidator<ENTITY>(this.orderedList, newPosition).coerce();
        this.orderedList.addAll(validPosition, entities);
        this.reorder();
    }

    private void checkMovedEntitiesAreInList(List<ENTITY> entities) {
        Set notInList = entities.stream().filter(e -> !this.orderedList.contains(e)).collect(Collectors.toSet());
        if (!notInList.isEmpty()) {
            String msg = String.format("%s cannot be moved, they are not in list %s", notInList, this.orderedList);
            throw new IllegalArgumentException(msg);
        }
    }

    public void reorder() {
        int i = 0;
        while (i < this.orderedList.size()) {
            Ordered node = (Ordered)this.orderedList.get(i);
            node.setOrder(i);
            ++i;
        }
    }
}

