/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.common.ordered;

import java.util.List;
import java.util.Objects;

public class ListIndexValidator<T> {
    private final List<T> list;
    private final Integer index;

    public ListIndexValidator(List<T> list, Integer index) {
        this.list = Objects.requireNonNull(list);
        this.index = index;
    }

    public boolean isValid() {
        return this.index != null && this.index < this.list.size() && this.index >= 0;
    }

    public Integer coerce() {
        if (this.index == null || this.index < 0) {
            return 0;
        }
        if (this.index > this.list.size()) {
            return this.list.size() - 1;
        }
        return this.index;
    }
}

