/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneMember;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.execution.EmptyTestSuiteTestPlanException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.security.annotation.InheritsAcls;

@Auditable
@Entity
@InheritsAcls(constrainedClass=Iteration.class, collectionName="testSuites")
public class TestSuite
extends BaseAuditableEntity
implements Identified,
Copiable,
TreeNode,
BoundEntity,
AttachmentHolder,
MilestoneMember,
HasExecutionStatus,
TestPlanOwner {
    public static final int MAX_NAME_SIZE = 255;
    public static final String SIMPLE_CASS_NAME = "org.squashtest.tm.domain.campaign.TestSuite";
    static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="test_suite_id_seq")
    @SequenceGenerator(name="test_suite_id_seq", sequenceName="test_suite_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @Column(name="UUID")
    @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}")
    private @NotNull @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}") String uuid;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus = ExecutionStatus.READY;
    @ManyToOne
    @JoinTable(name="ITERATION_TEST_SUITE", joinColumns={@JoinColumn(name="TEST_SUITE_ID", updatable=false, insertable=false)}, inverseJoinColumns={@JoinColumn(name="ITERATION_ID", updatable=false, insertable=false)})
    private Iteration iteration;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="TEST_PLAN_ORDER")
    @JoinTable(name="TEST_SUITE_TEST_PLAN_ITEM", inverseJoinColumns={@JoinColumn(name="TPI_ID", referencedColumnName="ITEM_TEST_PLAN_ID")}, joinColumns={@JoinColumn(name="SUITE_ID", referencedColumnName="ID")})
    private List<IterationTestPlanItem> testPlan = new LinkedList<IterationTestPlanItem>();
    @OneToMany(mappedBy="testSuite", cascade={CascadeType.REMOVE})
    private List<AutomatedSuite> automatedSuites = new ArrayList<AutomatedSuite>();

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.RUNNING);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SETTLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public TestSuite() {
        UUID newUUID = UUID.randomUUID();
        this.uuid = newUUID.toString();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name.trim();
    }

    public void rename(String newName) {
        String trimedName = newName.trim();
        if (!this.iteration.checkSuiteNameAvailable(trimedName)) {
            throw new DuplicateNameException("Cannot rename suite " + this.name + " : new name " + trimedName + " already exists in iteration " + this.iteration.getName());
        }
        this.name = trimedName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        return LEGAL_EXEC_STATUS;
    }

    void setIteration(@NotNull Iteration iteration) {
        Iteration iteration2 = iteration;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iteration2);
        this.iteration = iteration;
    }

    public Iteration getIteration() {
        return this.iteration;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    private boolean boundToThisSuite(IterationTestPlanItem item) {
        List<TestSuite> suites = item.getTestSuites();
        return !suites.isEmpty() && this.hasSame(suites);
    }

    private boolean hasSame(List<TestSuite> suites) {
        boolean result = false;
        for (TestSuite suite : suites) {
            if (this.id == null) {
                if (!this.equals(suite)) continue;
                result = true;
                continue;
            }
            if (!this.id.equals(suite.getId())) continue;
            result = true;
        }
        return result;
    }

    public IterationTestPlanItem getFirstTestPlanItem() throws EmptyTestSuiteTestPlanException {
        Iterator<IterationTestPlanItem> iterator = this.getTestPlan().iterator();
        if (iterator.hasNext()) {
            IterationTestPlanItem item = iterator.next();
            return item;
        }
        throw new EmptyTestSuiteTestPlanException(this);
    }

    public TestCase getFirstPlannedTestCase() throws EmptyTestSuiteTestPlanException {
        IterationTestPlanItem itpi = this.getFirstTestPlanItem();
        return itpi.getReferencedTestCase();
    }

    public IterationTestPlanItem getFirstTestPlanItem(String testerLogin) {
        for (IterationTestPlanItem item : this.getTestPlan()) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin)) continue;
            return item;
        }
        throw new EmptyTestSuiteTestPlanException(this);
    }

    public void bindTestPlanItems(List<IterationTestPlanItem> items) {
        for (IterationTestPlanItem item : items) {
            this.bindTestPlanItem(item);
        }
    }

    public void bindTestPlanItem(IterationTestPlanItem item) {
        if (!this.boundToThisSuite(item)) {
            this.testPlan.add(item);
            item.addTestSuite(this);
        }
    }

    public void unBindTestPlan(List<IterationTestPlanItem> items) {
        for (IterationTestPlanItem item : items) {
            this.unBindTestPlan(item);
        }
    }

    public void unBindTestPlan(IterationTestPlanItem item) {
        if (this.boundToThisSuite(item)) {
            this.testPlan.remove(item);
            item.getTestSuites().remove(this);
        }
    }

    public void bindTestPlanItemsById(List<Long> itemIds) {
        for (Long itemId : itemIds) {
            for (IterationTestPlanItem item : this.iteration.getTestPlans()) {
                if (!item.getId().equals(itemId)) continue;
                this.bindTestPlanItem(item);
            }
        }
    }

    public void reorderTestPlan(int newIndex, List<IterationTestPlanItem> movedItems) {
        if (!this.testPlan.isEmpty()) {
            this.testPlan.removeAll(movedItems);
            this.testPlan.addAll(newIndex, movedItems);
        }
    }

    public List<IterationTestPlanItem> createPastableCopyOfTestPlan() {
        LinkedList<IterationTestPlanItem> testPlanCopy = new LinkedList<IterationTestPlanItem>();
        List<IterationTestPlanItem> testPlanOriginal = this.getTestPlan();
        for (IterationTestPlanItem iterationTestPlanItem : testPlanOriginal) {
            if (iterationTestPlanItem.isTestCaseDeleted()) continue;
            IterationTestPlanItem testPlanItemCopy = iterationTestPlanItem.createCopy();
            testPlanCopy.add(testPlanItemCopy);
        }
        return testPlanCopy;
    }

    @Override
    public TestSuite createCopy() {
        TestSuite testSuiteCopy = new TestSuite();
        testSuiteCopy.setName(this.getName());
        testSuiteCopy.setDescription(this.getDescription());
        for (Attachment attach : this.getAttachmentList().getAllAttachments()) {
            Attachment copyAttach = attach.shallowCopy();
            testSuiteCopy.getAttachmentList().addAttachment(copyAttach);
        }
        return testSuiteCopy;
    }

    public boolean isFirstExecutableTestPlanItem(long itemId) {
        for (IterationTestPlanItem iterationTestPlanItem : this.testPlan) {
            if (!this.boundToThisSuite(iterationTestPlanItem) || iterationTestPlanItem.isTestCaseDeleted()) continue;
            return itemId == iterationTestPlanItem.getId();
        }
        return false;
    }

    @Override
    public boolean isFirstExecutableTestPlanItem(long itemId, String testerLogin) {
        for (IterationTestPlanItem iterationTestPlanItem : this.testPlan) {
            if (testerLogin != null && !iterationTestPlanItem.isAssignedToUser(testerLogin) || !this.boundToThisSuite(iterationTestPlanItem) || iterationTestPlanItem.isTestCaseDeleted()) continue;
            return itemId == iterationTestPlanItem.getId();
        }
        return false;
    }

    @Override
    public IterationTestPlanItem findNextExecutableTestPlanItem(long testPlanItemId) {
        return this.findNextExecutableTestPlanItem(testPlanItemId, null);
    }

    @Override
    public IterationTestPlanItem findNextExecutableTestPlanItem(long testPlanItemId, String testerLogin) {
        List<IterationTestPlanItem> remaining = this.getRemainingPlanById(testPlanItemId);
        for (IterationTestPlanItem item : remaining) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin) || !item.isExecutableThroughTestSuite()) continue;
            return item;
        }
        throw new TestPlanItemNotExecutableException("No more executable item in this suite's test plan");
    }

    public IterationTestPlanItem findFirstExecutableTestPlanItem() {
        return this.findFirstExecutableTestPlanItem(null);
    }

    @Override
    public IterationTestPlanItem findFirstExecutableTestPlanItem(String testerLogin) {
        IterationTestPlanItem firstTestPlanItem = this.getFirstTestPlanItem(testerLogin);
        if (firstTestPlanItem.isExecutableThroughTestSuite()) {
            return firstTestPlanItem;
        }
        return this.findNextExecutableTestPlanItem(firstTestPlanItem.getId(), testerLogin);
    }

    private List<IterationTestPlanItem> getRemainingPlanById(long testPlanItemId) {
        int i = 0;
        while (i < this.testPlan.size()) {
            if (testPlanItemId == this.testPlan.get(i).getId()) {
                return this.testPlan.subList(i + 1, this.testPlan.size());
            }
            ++i;
        }
        throw new IllegalArgumentException("Item[" + testPlanItemId + "] does not belong to test plan of TestSuite[" + this.id + ']');
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.TEST_SUITE;
    }

    @Override
    public Project getProject() {
        if (this.iteration != null) {
            return this.iteration.getProject();
        }
        return null;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<IterationTestPlanItem> getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(List<IterationTestPlanItem> testPlan) {
        this.testPlan = testPlan;
    }

    @Override
    public Set<Milestone> getMilestones() {
        return this.getIteration().getMilestones();
    }

    @Override
    public boolean isMemberOf(Milestone milestone) {
        return this.getIteration().isMemberOf(milestone);
    }

    @Override
    public Boolean doMilestonesAllowCreation() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectCreateAndDelete()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    @Override
    public Boolean doMilestonesAllowEdition() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectModification()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Deprecated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public List<AutomatedSuite> getAutomatedSuites() {
        return this.automatedSuites;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.TEST_SUITE, this.id);
    }
}

