/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.campaign.TestPlanStatus;
import org.squashtest.tm.domain.execution.ExecutionStatus;

public final class TestPlanStatistics {
    private int nbTestCases;
    private int progression;
    private TestPlanStatus status;
    private int nbDone;
    private Map<String, Integer> statisticValues;

    public TestPlanStatistics() {
    }

    public TestPlanStatistics(LinkedHashMap<ExecutionStatus, Integer> statisticValues) {
        HashMap<String, Integer> statMaps = new HashMap<String, Integer>();
        Set<ExecutionStatus> keys = statisticValues.keySet();
        keys.forEach(key -> {
            Integer n = statMaps.put(key.name(), (Integer)statisticValues.get(key));
        });
        this.statisticValues = statMaps;
        this.init();
    }

    public TestPlanStatistics(Map<String, Integer> statisticValues) {
        this.statisticValues = statisticValues;
        this.init();
    }

    public int getNbTestCases() {
        return this.nbTestCases;
    }

    public int getProgression() {
        return this.progression;
    }

    public int getNbSuccess() {
        return this.findIntValue(ExecutionStatus.SUCCESS.name()) + this.findIntValue(ExecutionStatus.WARNING.name());
    }

    public int getNbFailure() {
        return this.findIntValue(ExecutionStatus.FAILURE.name());
    }

    public int getNbUntestable() {
        return this.findIntValue(ExecutionStatus.UNTESTABLE.name());
    }

    public int getNbSettled() {
        return this.findIntValue(ExecutionStatus.SETTLED.name());
    }

    public int getNbBlocked() {
        return this.findIntValue(ExecutionStatus.BLOCKED.name()) + this.findIntValue(ExecutionStatus.ERROR.name());
    }

    public int getNbReady() {
        return this.findIntValue(ExecutionStatus.READY.name());
    }

    public int getNbRunning() {
        return this.findIntValue(ExecutionStatus.RUNNING.name());
    }

    public TestPlanStatus getStatus() {
        return this.status;
    }

    public int getNbDone() {
        return this.nbDone;
    }

    private void init() {
        this.computeNbTestCases();
        this.computeDone();
        this.computeProgression();
        this.status = TestPlanStatus.getStatus(this);
    }

    private int findIntValue(String key) {
        Integer integer = this.statisticValues.get(key);
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    private void computeProgression() {
        if (this.getNbTestCases() != 0) {
            BigDecimal progressionBD = new BigDecimal(this.nbDone).divide(new BigDecimal(this.getNbTestCases()), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            this.progression = progressionBD.intValue();
        } else {
            this.progression = 0;
        }
    }

    private void computeNbTestCases() {
        Collection<Integer> all = this.statisticValues.values();
        int acc = 0;
        for (Integer count : all) {
            acc += count.intValue();
        }
        this.nbTestCases = acc;
    }

    private void computeDone() {
        this.nbDone = this.getNbSettled() + this.getNbUntestable() + this.getNbBlocked() + this.getNbFailure() + this.getNbSuccess();
    }
}

