/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.ActualTimePeriod;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CascadingAutoDateComparatorBuilder;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.ScheduledTimePeriod;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneMember;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.exception.execution.EmptyIterationTestPlanException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Auditable
@Entity
public class Iteration
extends BaseAuditableEntity
implements AttachmentHolder,
NodeContainer<TestSuite>,
TreeNode,
Copiable,
Identified,
BoundEntity,
MilestoneMember,
TestPlanOwner {
    private static final String ITERATION_ID = "ITERATION_ID";
    public static final String SIMPLE_CLASS_NAME = "org.squashtest.tm.domain.campaign.Iteration";
    public static final int MAX_REF_SIZE = 50;
    @Id
    @Column(name="ITERATION_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="iteration_iteration_id_seq")
    @SequenceGenerator(name="iteration_iteration_id_seq", sequenceName="iteration_iteration_id_seq", allocationSize=1)
    private Long id;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String reference = "";
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="ITERATION_STATUS")
    private IterationStatus status = IterationStatus.UNDEFINED;
    @Embedded
    @Valid
    private ScheduledTimePeriod scheduledPeriod = new ScheduledTimePeriod();
    @Embedded
    @Valid
    private final ActualTimePeriod actualPeriod = new ActualTimePeriod();
    @NotNull
    @Column(name="UUID")
    @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}")
    private @NotNull @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}") String uuid;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="CAMPAIGN_ITERATION", joinColumns={@JoinColumn(name="ITERATION_ID", updatable=false, insertable=false)}, inverseJoinColumns={@JoinColumn(name="CAMPAIGN_ID", updatable=false, insertable=false)})
    private Campaign campaign;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="ITEM_TEST_PLAN_ORDER")
    @JoinTable(name="ITEM_TEST_PLAN_LIST", joinColumns={@JoinColumn(name="ITERATION_ID")}, inverseJoinColumns={@JoinColumn(name="ITEM_TEST_PLAN_ID")})
    private final List<IterationTestPlanItem> testPlans = new ArrayList<IterationTestPlanItem>();
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="ITERATION_TEST_SUITE_ORDER")
    @JoinTable(name="ITERATION_TEST_SUITE", joinColumns={@JoinColumn(name="ITERATION_ID")}, inverseJoinColumns={@JoinColumn(name="TEST_SUITE_ID")})
    private List<TestSuite> testSuites = new ArrayList<TestSuite>();
    @OneToMany(mappedBy="iteration", cascade={CascadeType.REMOVE})
    private List<AutomatedSuite> automatedSuites = new ArrayList<AutomatedSuite>();

    public Iteration() {
        UUID newUUID = UUID.randomUUID();
        this.uuid = newUUID.toString();
    }

    public List<Execution> getExecutions() {
        ArrayList<Execution> listExec = new ArrayList<Execution>();
        for (IterationTestPlanItem testplan : this.testPlans) {
            listExec.addAll(testplan.getExecutions());
        }
        return listExec;
    }

    @Override
    public void setName(String name) {
        this.name = name.trim();
    }

    @Override
    @NotBlank
    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getFullName() {
        if (StringUtils.isBlank((CharSequence)this.reference)) {
            return this.getName();
        }
        return String.valueOf(this.getReference()) + " - " + this.getName();
    }

    public IterationStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull IterationStatus status) {
        IterationStatus iterationStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iterationStatus);
        this.status = status;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setScheduledStartDate(Date startDate) {
        this.getScheduledPeriod().setScheduledStartDate(startDate);
    }

    public Date getScheduledStartDate() {
        return this.getScheduledPeriod().getScheduledStartDate();
    }

    public void setScheduledEndDate(Date endDate) {
        this.getScheduledPeriod().setScheduledEndDate(endDate);
    }

    public Date getScheduledEndDate() {
        return this.getScheduledPeriod().getScheduledEndDate();
    }

    public void setActualStartDate(Date startDate) {
        this.actualPeriod.setActualStartDate(startDate);
        if (this.getCampaign() != null) {
            this.getCampaign().updateActualStart(startDate);
        }
    }

    public Date getActualStartDate() {
        return this.actualPeriod.getActualStartDate();
    }

    public void setActualEndDate(Date endDate) {
        this.actualPeriod.setActualEndDate(endDate);
        if (this.getCampaign() != null) {
            this.getCampaign().updateActualEnd(endDate);
        }
    }

    public Date getActualEndDate() {
        return this.actualPeriod.getActualEndDate();
    }

    public boolean isActualStartAuto() {
        return this.actualPeriod.isActualStartAuto();
    }

    public boolean isActualEndAuto() {
        return this.actualPeriod.isActualEndAuto();
    }

    public void setActualStartAuto(boolean actualStartAuto) {
        this.actualPeriod.setActualStartAuto(actualStartAuto);
        if (this.actualPeriod.isActualStartAuto()) {
            this.autoSetActualStartDate();
        }
    }

    public void setActualEndAuto(boolean actualEndAuto) {
        this.actualPeriod.setActualEndAuto(actualEndAuto);
        if (this.actualPeriod.isActualEndAuto()) {
            this.autoSetActualEndDate();
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    private ScheduledTimePeriod getScheduledPeriod() {
        if (this.scheduledPeriod == null) {
            this.scheduledPeriod = new ScheduledTimePeriod();
        }
        return this.scheduledPeriod;
    }

    @Override
    public Iteration createCopy() {
        Iteration clone = new Iteration();
        clone.setName(this.getName());
        clone.setDescription(this.getDescription());
        clone.setReference(this.getReference());
        this.copyPlanning(clone);
        for (IterationTestPlanItem itemTestPlan : this.testPlans) {
            clone.addTestPlan(itemTestPlan.createCopy());
        }
        for (Attachment attach : this.getAttachmentList().getAllAttachments()) {
            Attachment copyAttach = attach.shallowCopy();
            clone.getAttachmentList().addAttachment(copyAttach);
        }
        return clone;
    }

    private void copyPlanning(Iteration clone) {
        clone.setActualEndAuto(this.isActualEndAuto());
        clone.setActualStartAuto(this.isActualStartAuto());
        if (this.getScheduledStartDate() != null) {
            clone.setScheduledStartDate((Date)this.getScheduledStartDate().clone());
        }
        if (this.getScheduledEndDate() != null) {
            clone.setScheduledEndDate((Date)this.getScheduledEndDate().clone());
        }
    }

    public List<IterationTestPlanItem> getTestPlans() {
        return this.testPlans;
    }

    public List<TestCase> getPlannedTestCase() {
        ArrayList<TestCase> list = new ArrayList<TestCase>(this.testPlans.size());
        for (IterationTestPlanItem iterTestPlan : this.testPlans) {
            TestCase testCase = iterTestPlan.getReferencedTestCase();
            if (testCase == null) continue;
            list.add(testCase);
        }
        return list;
    }

    public void moveTestSuites(int newIndex, List<TestSuite> movedItems) {
        if (!this.testSuites.isEmpty()) {
            this.testSuites.removeAll(movedItems);
            this.testSuites.addAll(newIndex, movedItems);
        }
    }

    public void removeTestSuite(@NotNull TestSuite testSuite) {
        TestSuite testSuite2 = testSuite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite2);
        this.testSuites.remove(testSuite);
    }

    public void removeItemFromTestPlan(@NotNull IterationTestPlanItem testPlanItem) {
        IterationTestPlanItem iterationTestPlanItem = testPlanItem;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iterationTestPlanItem);
        this.testPlans.remove(testPlanItem);
        for (TestSuite testSuite : this.testSuites) {
            testSuite.getTestPlan().remove(testPlanItem);
        }
    }

    public void addTestPlan(@NotNull IterationTestPlanItem testPlan) {
        IterationTestPlanItem iterationTestPlanItem = testPlan;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iterationTestPlanItem);
        if (testPlan.getReferencedTestCase() == null) {
            return;
        }
        this.testPlans.add(testPlan);
        testPlan.setIteration(this);
    }

    public int findTestCaseIndexInTestPlan(long testCaseId) {
        ListIterator<IterationTestPlanItem> iterator = this.testPlans.listIterator();
        while (iterator.hasNext()) {
            IterationTestPlanItem itemTestPlan = iterator.next();
            if (itemTestPlan.isTestCaseDeleted() || !itemTestPlan.getReferencedTestCase().getId().equals(testCaseId)) continue;
            return iterator.previousIndex();
        }
        throw new UnknownEntityException(testCaseId, TestCase.class);
    }

    public int findItemIndexInTestPlan(long testPlanId) {
        ListIterator<IterationTestPlanItem> iterator = this.testPlans.listIterator();
        while (iterator.hasNext()) {
            IterationTestPlanItem itemTestPlan = iterator.next();
            if (!itemTestPlan.getId().equals(testPlanId)) continue;
            return iterator.previousIndex();
        }
        throw new UnknownEntityException(testPlanId, IterationTestPlanItem.class);
    }

    @Deprecated
    public void moveTestPlan(int currentPosition, int newPosition) {
        if (currentPosition == newPosition) {
            return;
        }
        IterationTestPlanItem testCaseToMove = this.testPlans.get(currentPosition);
        this.testPlans.remove(currentPosition);
        this.testPlans.add(newPosition, testCaseToMove);
    }

    public void moveTestPlans(int newIndex, List<IterationTestPlanItem> movedItems) {
        if (!this.testPlans.isEmpty()) {
            this.testPlans.removeAll(movedItems);
            this.testPlans.addAll(newIndex, movedItems);
        }
    }

    public int getIndexOf(IterationTestPlanItem item) {
        int i = 0;
        for (IterationTestPlanItem testPlan : this.testPlans) {
            if (item.equals(testPlan)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isFirstExecutableTestPlanItem(long itemId, String testerLogin) {
        for (IterationTestPlanItem iterationTestPlanItem : this.testPlans) {
            if (testerLogin != null && !iterationTestPlanItem.isAssignedToUser(testerLogin) || iterationTestPlanItem.isTestCaseDeleted()) continue;
            return itemId == iterationTestPlanItem.getId();
        }
        return false;
    }

    @Override
    public IterationTestPlanItem findNextExecutableTestPlanItem(long testPlanItemId) {
        return this.findNextExecutableTestPlanItem(testPlanItemId, null);
    }

    @Override
    public IterationTestPlanItem findNextExecutableTestPlanItem(long testPlanItemId, String testerLogin) {
        List<IterationTestPlanItem> remaining = this.getRemainingPlanById(testPlanItemId);
        for (IterationTestPlanItem item : remaining) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin) || !item.isExecutableThroughTestSuite()) continue;
            return item;
        }
        throw new TestPlanItemNotExecutableException("No more executable item in this iteration's test plan");
    }

    @Override
    public IterationTestPlanItem findFirstExecutableTestPlanItem(String testerLogin) {
        IterationTestPlanItem firstTestPlanItem = this.getFirstTestPlanItem(testerLogin);
        if (firstTestPlanItem.isExecutableThroughTestSuite()) {
            return firstTestPlanItem;
        }
        return this.findNextExecutableTestPlanItem(firstTestPlanItem.getId(), testerLogin);
    }

    private IterationTestPlanItem getFirstTestPlanItem(String testerLogin) {
        for (IterationTestPlanItem item : this.getTestPlans()) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin)) continue;
            return item;
        }
        throw new EmptyIterationTestPlanException(this);
    }

    private List<IterationTestPlanItem> getRemainingPlanById(long testPlanItemId) {
        int i = 0;
        while (i < this.testPlans.size()) {
            if (testPlanItemId == this.testPlans.get(i).getId()) {
                return this.testPlans.subList(i + 1, this.testPlans.size());
            }
            ++i;
        }
        throw new IllegalArgumentException("Item[" + testPlanItemId + "] does not belong to test plan of Iteration[" + this.id + ']');
    }

    public List<TestSuite> getTestSuites() {
        return this.testSuites;
    }

    public TestSuite getTestSuiteByName(String tsName) {
        for (TestSuite ts : this.testSuites) {
            if (!ts.getName().equals(tsName)) continue;
            return ts;
        }
        throw new NoSuchElementException("Iteration " + this.id + " : cannot find test suite named '" + tsName + "'");
    }

    public void addTestSuite(TestSuite suite) {
        if (!this.checkSuiteNameAvailable(suite.getName())) {
            throw new DuplicateNameException("cannot add suite to iteration " + this.getName() + " : suite named " + suite.getName() + " already exists");
        }
        this.testSuites.add(suite);
        suite.setIteration(this);
    }

    public void addTestSuite(TestSuite suite, int position) {
        if (!this.checkSuiteNameAvailable(suite.getName())) {
            throw new DuplicateNameException("cannot add suite to iteration " + this.getName() + " : suite named " + suite.getName() + " already exists");
        }
        this.testSuites.add(position, suite);
        suite.setIteration(this);
    }

    public boolean checkSuiteNameAvailable(String name) {
        for (TestSuite suite : this.testSuites) {
            if (!suite.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public boolean hasTestSuites() {
        return !this.testSuites.isEmpty();
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Project getProject() {
        if (this.campaign != null) {
            return this.campaign.getProject();
        }
        return null;
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.getProject().getCampaignLibrary();
    }

    public void updateAutoDates(Date newItemTestPlanDate) {
        if (this.isActualStartAuto()) {
            this.updateAutoDatesAcutalStart(newItemTestPlanDate);
        }
        if (this.isActualEndAuto()) {
            this.updateAutoDatesActualEnd(newItemTestPlanDate);
        }
    }

    private void updateAutoDatesActualEnd(Date newItemTestPlanDate) {
        if (this.actualEndDateUpdateAuthorization()) {
            if (this.getActualEndDate() == null) {
                this.setActualEndDate(newItemTestPlanDate);
            } else if (newItemTestPlanDate != null && this.getActualEndDate().compareTo(newItemTestPlanDate) < 0) {
                this.setActualEndDate(newItemTestPlanDate);
            } else {
                this.autoSetActualEndDateNoCheck();
            }
        } else {
            this.setActualEndDate(null);
        }
    }

    private void updateAutoDatesAcutalStart(Date newItemTestPlanDate) {
        if (this.getActualStartDate() == null) {
            this.setActualStartDate(newItemTestPlanDate);
        } else if (newItemTestPlanDate != null && this.getActualStartDate().compareTo(newItemTestPlanDate) > 0) {
            this.setActualStartDate(newItemTestPlanDate);
        } else {
            this.autoSetActualStartDate();
        }
    }

    private void autoSetActualStartDate() {
        Date actualDate = this.getFirstExecutedTestPlanDate();
        this.setActualStartDate(actualDate);
    }

    private void autoSetActualEndDateNoCheck() {
        Date actualDate = this.getLastExecutedTestPlanDate();
        this.setActualEndDate(actualDate);
    }

    private void autoSetActualEndDate() {
        Date actualDate = null;
        if (this.actualEndDateUpdateAuthorization()) {
            actualDate = this.getLastExecutedTestPlanDate();
        }
        this.setActualEndDate(actualDate);
    }

    private boolean actualEndDateUpdateAuthorization() {
        boolean toReturn = true;
        for (IterationTestPlanItem testPlanItem : this.testPlans) {
            if (testPlanItem.getExecutionStatus().isTerminatedStatus()) continue;
            toReturn = false;
        }
        return toReturn;
    }

    private Date getFirstExecutedTestPlanDate() {
        if (this.getTestPlans().isEmpty()) {
            return null;
        }
        IterationTestPlanItem firstTestPlan = Collections.min(this.getTestPlans(), CascadingAutoDateComparatorBuilder.buildTestPlanFirstDateSorter());
        return firstTestPlan.getLastExecutedOn();
    }

    private Date getLastExecutedTestPlanDate() {
        if (this.getTestPlans().isEmpty()) {
            return null;
        }
        IterationTestPlanItem lastTestPlan = Collections.max(this.getTestPlans(), CascadingAutoDateComparatorBuilder.buildTestPlanLastDateSorter());
        return lastTestPlan.getLastExecutedOn();
    }

    public Map<TestSuite, List<Integer>> createTestSuitesPastableCopy() {
        HashMap<TestSuite, List<Integer>> resultMap = new HashMap<TestSuite, List<Integer>>();
        List<IterationTestPlanItem> testPlanWithoutDeletedTestCases = this.getTestPlanWithoutDeletedTestCases();
        for (TestSuite testSuite : this.getTestSuites()) {
            List<IterationTestPlanItem> testSuiteTestPlan = testSuite.getTestPlan();
            TestSuite testSuiteCopy = testSuite.createCopy();
            ArrayList<Integer> testPlanIndex = new ArrayList<Integer>();
            for (IterationTestPlanItem iterationTestPlanItem : testSuiteTestPlan) {
                int testPlanItemIndex = testPlanWithoutDeletedTestCases.indexOf(iterationTestPlanItem);
                if (testPlanItemIndex <= -1) continue;
                testPlanIndex.add(testPlanItemIndex);
            }
            resultMap.put(testSuiteCopy, testPlanIndex);
        }
        return resultMap;
    }

    private List<IterationTestPlanItem> getTestPlanWithoutDeletedTestCases() {
        LinkedList<IterationTestPlanItem> testPlanResult = new LinkedList<IterationTestPlanItem>();
        for (IterationTestPlanItem itpi : this.getTestPlans()) {
            if (itpi.isTestCaseDeleted()) continue;
            testPlanResult.add(itpi);
        }
        return testPlanResult;
    }

    public void updateAutoDatesAfterExecutionDetach(IterationTestPlanItem iterationTestPlanItem) {
        this.updateAutoEndDateAfterExecutionDetach(iterationTestPlanItem);
        this.updateStartAutoDateAfterExecutionDetach();
    }

    private void updateStartAutoDateAfterExecutionDetach() {
        if (this.isActualStartAuto()) {
            this.autoSetActualStartDate();
        }
    }

    private void updateAutoEndDateAfterExecutionDetach(IterationTestPlanItem iterationTestPlanItem) {
        if (this.isActualEndAuto()) {
            if (!iterationTestPlanItem.getExecutionStatus().isTerminatedStatus()) {
                this.setActualEndDate(null);
            } else {
                this.autoSetActualEndDate();
            }
        }
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.ITERATION;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addContent(@NotNull TestSuite testSuite) throws DuplicateNameException, NullArgumentException {
        TestSuite testSuite2 = testSuite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite2);
        this.addTestSuite(testSuite);
    }

    @Override
    public void addContent(@NotNull TestSuite testSuite, int position) throws DuplicateNameException, NullArgumentException {
        TestSuite testSuite2 = testSuite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite2);
        this.addTestSuite(testSuite, position);
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        return this.checkSuiteNameAvailable(name);
    }

    @Override
    public List<TestSuite> getContent() {
        return this.getTestSuites();
    }

    @Override
    public Collection<TestSuite> getOrderedContent() {
        return this.getTestSuites();
    }

    @Override
    public boolean hasContent() {
        return !this.getContent().isEmpty();
    }

    @Override
    public void removeContent(TestSuite contentToRemove) throws NullArgumentException {
        this.removeTestSuite(contentToRemove);
    }

    @Override
    public List<String> getContentNames() {
        ArrayList<String> testSuitesNames = new ArrayList<String>(this.testSuites.size());
        for (TestSuite suite : this.testSuites) {
            testSuitesNames.add(suite.getName());
        }
        return testSuitesNames;
    }

    @Override
    public Set<Milestone> getMilestones() {
        return this.getCampaign().getMilestones();
    }

    @Override
    public boolean isMemberOf(Milestone milestone) {
        return this.getCampaign().isMemberOf(milestone);
    }

    @Override
    public Boolean doMilestonesAllowCreation() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectCreateAndDelete()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    @Override
    public Boolean doMilestonesAllowEdition() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectModification()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Deprecated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public List<AutomatedSuite> getAutomatedSuites() {
        return this.automatedSuites;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.ITERATION, this.getId());
    }
}

