/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.campaign.ActualTimePeriod;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignLibraryNodeVisitor;
import org.squashtest.tm.domain.campaign.CampaignStatus;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.CascadingAutoDateComparatorBuilder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.ScheduledTimePeriod;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.DuplicateNameException;

@Entity
@PrimaryKeyJoinColumn(name="CLN_ID")
public class Campaign
extends CampaignLibraryNode
implements NodeContainer<Iteration>,
BoundEntity,
MilestoneHolder {
    public static final String SIMPLE_CASS_NAME = "org.squashtest.tm.domain.campaign.Campaign";
    public static final int MAX_REF_SIZE = 50;
    private static final String FULL_NAME_SEPARATOR = " - ";
    @Embedded
    @Valid
    private ScheduledTimePeriod scheduledPeriod = new ScheduledTimePeriod();
    @Embedded
    @Valid
    private final ActualTimePeriod actualPeriod = new ActualTimePeriod();
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="ITERATION_ORDER")
    @JoinTable(name="CAMPAIGN_ITERATION", joinColumns={@JoinColumn(name="CAMPAIGN_ID")}, inverseJoinColumns={@JoinColumn(name="ITERATION_ID")})
    private final List<Iteration> iterations = new ArrayList<Iteration>();
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, orphanRemoval=true)
    @OrderColumn(name="TEST_PLAN_ORDER")
    @JoinColumn(name="CAMPAIGN_ID")
    private final List<CampaignTestPlanItem> testPlan = new ArrayList<CampaignTestPlanItem>();
    @ManyToMany
    @JoinTable(name="MILESTONE_CAMPAIGN", joinColumns={@JoinColumn(name="CAMPAIGN_ID")}, inverseJoinColumns={@JoinColumn(name="MILESTONE_ID")})
    private Set<Milestone> milestones = new HashSet<Milestone>();
    @NotNull
    @Size(min=0, max=50)
    private @NotNull @Size(min=0, max=50) String reference = "";
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="CAMPAIGN_STATUS")
    private CampaignStatus status = CampaignStatus.UNDEFINED;

    @Override
    public void accept(CampaignLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    public void setScheduledStartDate(Date startDate) {
        this.getScheduledPeriod().setScheduledStartDate(startDate);
    }

    public Date getScheduledStartDate() {
        return this.getScheduledPeriod().getScheduledStartDate();
    }

    public void setScheduledEndDate(Date endDate) {
        this.getScheduledPeriod().setScheduledEndDate(endDate);
    }

    public Date getScheduledEndDate() {
        return this.getScheduledPeriod().getScheduledEndDate();
    }

    public Date getActualStartDate() {
        return this.actualPeriod.getActualStartDate();
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualPeriod.setActualStartDate(actualStartDate);
    }

    public Date getActualEndDate() {
        return this.actualPeriod.getActualEndDate();
    }

    public List<CampaignTestPlanItem> getTestPlan() {
        return this.testPlan;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualPeriod.setActualEndDate(actualEndDate);
    }

    public boolean isActualStartAuto() {
        return this.actualPeriod.isActualStartAuto();
    }

    public boolean isActualEndAuto() {
        return this.actualPeriod.isActualEndAuto();
    }

    public CampaignStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull CampaignStatus status) {
        CampaignStatus campaignStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaignStatus);
        this.status = status;
    }

    public void setActualStartAuto(boolean actualStartAuto) {
        this.actualPeriod.setActualStartAuto(actualStartAuto);
        if (this.actualPeriod.isActualStartAuto()) {
            this.autoSetActualStartDate();
        }
    }

    public void setActualEndAuto(boolean actualEndAuto) {
        this.actualPeriod.setActualEndAuto(actualEndAuto);
        if (this.actualPeriod.isActualEndAuto()) {
            this.autoSetActualEndDate();
        }
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getFullName() {
        if (StringUtils.isBlank((CharSequence)this.reference)) {
            return this.getName();
        }
        return String.valueOf(this.getReference()) + FULL_NAME_SEPARATOR + this.getName();
    }

    public CampaignTestPlanItem findTestPlanItem(TestCase testCase) {
        for (CampaignTestPlanItem campTestPlan : this.getTestPlan()) {
            if (!campTestPlan.getReferencedTestCase().equals(testCase)) continue;
            return campTestPlan;
        }
        return null;
    }

    public void addToTestPlan(@NotNull CampaignTestPlanItem itemTestPlan) {
        CampaignTestPlanItem campaignTestPlanItem = itemTestPlan;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaignTestPlanItem);
        this.getTestPlan().add(itemTestPlan);
        itemTestPlan.setCampaign(this);
    }

    public void removeTestPlanItem(@NotNull CampaignTestPlanItem itemTestPlan) {
        CampaignTestPlanItem campaignTestPlanItem = itemTestPlan;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaignTestPlanItem);
        this.getTestPlan().remove(itemTestPlan);
    }

    public void removeTestPlanItem(long itemId) {
        Iterator<CampaignTestPlanItem> it = this.testPlan.iterator();
        while (it.hasNext()) {
            if (it.next().getId() != itemId) continue;
            it.remove();
            return;
        }
    }

    public void removeTestPlanItems(List<Long> itemIds) {
        Iterator<CampaignTestPlanItem> it = this.testPlan.iterator();
        while (it.hasNext()) {
            if (!itemIds.contains(it.next().getId())) continue;
            it.remove();
        }
    }

    public void removeIteration(@NotNull Iteration iteration) {
        Iteration iteration2 = iteration;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iteration2);
        this.getIterations().remove(iteration);
    }

    public void moveIterations(int newIndex, List<Iteration> moved) {
        if (!this.iterations.isEmpty()) {
            this.iterations.removeAll(moved);
            this.iterations.addAll(newIndex, moved);
        }
    }

    public List<Iteration> getIterations() {
        return this.iterations;
    }

    public void addIteration(@NotNull Iteration iteration) {
        Iteration iteration2 = iteration;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iteration2);
        if (!this.isContentNameAvailable(iteration.getName())) {
            throw new DuplicateNameException(iteration.getName(), iteration.getName());
        }
        this.getIterations().add(iteration);
        iteration.setCampaign(this);
    }

    public void addIteration(@NotNull Iteration iteration, int position) {
        Iteration iteration2 = iteration;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iteration2);
        if (!this.isContentNameAvailable(iteration.getName())) {
            throw new DuplicateNameException(iteration.getName(), iteration.getName());
        }
        this.getIterations().add(position, iteration);
        iteration.setCampaign(this);
    }

    private ScheduledTimePeriod getScheduledPeriod() {
        if (this.scheduledPeriod == null) {
            this.scheduledPeriod = new ScheduledTimePeriod();
        }
        return this.scheduledPeriod;
    }

    @Override
    public Campaign createCopy() {
        Campaign copy = new Campaign();
        copy.setName(this.getName());
        copy.setReference(this.getReference());
        copy.setDescription(this.getDescription());
        if (this.getScheduledStartDate() != null) {
            copy.setScheduledStartDate((Date)this.getScheduledStartDate().clone());
        }
        if (this.getScheduledEndDate() != null) {
            copy.setScheduledEndDate((Date)this.getScheduledEndDate().clone());
        }
        copy.setActualEndAuto(this.isActualEndAuto());
        copy.setActualStartAuto(this.isActualStartAuto());
        for (Attachment tcAttach : this.getAttachmentList().getAllAttachments()) {
            Attachment atCopy = tcAttach.shallowCopy();
            copy.getAttachmentList().addAttachment(atCopy);
        }
        for (CampaignTestPlanItem itemTestPlan : this.getTestPlan()) {
            copy.addToTestPlan(itemTestPlan.createCampaignlessCopy());
        }
        copy.notifyAssociatedWithProject((Project)this.getProject());
        copy.bindSameMilestones(this);
        return copy;
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        for (Iteration content : this.getIterations()) {
            if (!content.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void updateActualStart(Date newIterationStartDate) {
        if (this.isActualStartAuto()) {
            if (this.getActualStartDate() == null) {
                this.setActualStartDate(newIterationStartDate);
            } else if (newIterationStartDate != null && this.getActualStartDate().compareTo(newIterationStartDate) > 0) {
                this.setActualStartDate(newIterationStartDate);
            } else {
                this.autoSetActualStartDate();
            }
        }
    }

    public void updateActualEnd(Date newIterationEndDate) {
        if (this.isActualEndAuto()) {
            if (this.getActualEndDate() == null) {
                this.setActualEndDate(newIterationEndDate);
            } else if (newIterationEndDate != null && this.getActualEndDate().compareTo(newIterationEndDate) < 0) {
                this.setActualEndDate(newIterationEndDate);
            } else {
                this.autoSetActualEndDate();
            }
        }
    }

    private void autoSetActualStartDate() {
        Date actualDate = this.getFirstIterationActualStartDate();
        this.setActualStartDate(actualDate);
    }

    private void autoSetActualEndDate() {
        Date actualDate = this.getLastIterationActualEndDate();
        this.setActualEndDate(actualDate);
    }

    private Date getFirstIterationActualStartDate() {
        Iteration firstIteration = this.getFirstIteration();
        if (firstIteration != null) {
            return firstIteration.getActualStartDate();
        }
        return null;
    }

    private Iteration getFirstIteration() {
        if (this.getIterations().isEmpty()) {
            return null;
        }
        return Collections.min(this.getIterations(), CascadingAutoDateComparatorBuilder.buildIterationActualStartOrder());
    }

    private Date getLastIterationActualEndDate() {
        Iteration lastIteration = this.getLastIteration();
        if (lastIteration != null) {
            return lastIteration.getActualEndDate();
        }
        return null;
    }

    private Iteration getLastIteration() {
        if (this.getIterations().isEmpty()) {
            return null;
        }
        return Collections.max(this.getIterations(), CascadingAutoDateComparatorBuilder.buildIterationActualEndOrder());
    }

    public boolean testPlanContains(@NotNull TestCase tc) {
        TestCase testCase = tc;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase);
        return this.findTestPlanItem(tc) != null;
    }

    public boolean hasIterations() {
        return !this.iterations.isEmpty();
    }

    public void moveTestPlanItems(int targetIndex, List<Long> itemIds) {
        if (itemIds.isEmpty()) {
            return;
        }
        ArrayList<CampaignTestPlanItem> moved = new ArrayList<CampaignTestPlanItem>(itemIds.size());
        for (CampaignTestPlanItem item : this.testPlan) {
            if (!itemIds.contains(item.getId())) continue;
            moved.add(item);
        }
        this.testPlan.removeAll(moved);
        this.testPlan.addAll(targetIndex, moved);
    }

    private void bindSameMilestones(Campaign src) {
        for (Milestone m : src.getMilestones()) {
            this.bindMilestone(m);
        }
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.CAMPAIGN;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<Iteration> getContent() {
        ArrayList<Iteration> iterationList = new ArrayList<Iteration>();
        iterationList.addAll(this.getIterations());
        return iterationList;
    }

    @Override
    public List<Iteration> getOrderedContent() {
        return this.getIterations();
    }

    @Override
    public boolean hasContent() {
        return !this.getContent().isEmpty();
    }

    @Override
    public void addContent(Iteration iteration) throws DuplicateNameException, NullArgumentException {
        Iteration iteration2 = iteration;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iteration2);
        this.addIteration(iteration);
    }

    @Override
    public void addContent(Iteration iteration, int position) throws DuplicateNameException, NullArgumentException {
        Iteration iteration2 = iteration;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iteration2);
        this.addIteration(iteration, position);
    }

    @Override
    public void removeContent(Iteration contentToRemove) throws NullArgumentException {
        this.removeIteration(contentToRemove);
    }

    @Override
    public List<String> getContentNames() {
        ArrayList<String> iterationNames = new ArrayList<String>(this.iterations.size());
        for (Iteration iteration : this.iterations) {
            iterationNames.add(iteration.getName());
        }
        return iterationNames;
    }

    @Override
    public Set<Milestone> getMilestones() {
        return this.milestones;
    }

    @Override
    public boolean isMemberOf(Milestone milestone) {
        return this.milestones.contains(milestone);
    }

    @Override
    public void bindMilestone(Milestone milestone) {
        this.milestones.clear();
        this.milestones.add(milestone);
    }

    @Override
    public void unbindMilestone(Milestone milestone) {
        this.unbindMilestone(milestone.getId());
    }

    @Override
    public void unbindMilestone(Long milestoneId) {
        Iterator<Milestone> iter = this.milestones.iterator();
        while (iter.hasNext()) {
            Milestone m = iter.next();
            if (!m.getId().equals(milestoneId)) continue;
            iter.remove();
            break;
        }
    }

    @Override
    public void unbindAllMilestones() {
        this.milestones.clear();
    }

    public boolean isBindableToMilestone() {
        return this.milestonesAllowBind();
    }

    private boolean milestonesAllowBind() {
        for (Milestone m : this.milestones) {
            if (m.getStatus().isAllowObjectModification()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean doMilestonesAllowCreation() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectCreateAndDelete()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    @Override
    public Boolean doMilestonesAllowEdition() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectModification()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.CAMPAIGN, this.getId());
    }
}

