/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bdd.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;

public final class ActionWordUtil {
    private static final List<Character> ESCAPABLE_CHARS = Arrays.asList(Character.valueOf('\\'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\"'));

    private ActionWordUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated.");
    }

    public static String replaceExtraSpacesInText(@NotNull String text) {
        String string = text;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return text.replaceAll("[\\s]+", " ");
    }

    public static boolean hasNumber(@NotNull String inputText) {
        String[] strArrays;
        String string = inputText;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        String formattedInput = ActionWordUtil.replaceExtraSpacesInText(inputText);
        String[] stringArray = strArrays = formattedInput.split("\\s");
        int n = strArrays.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (ActionWordUtil.isNumber(word)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isNumber(String inputWord) {
        return inputWord.matches("-?\\d+(([.,])\\d+)?");
    }

    public static String updateNumberValue(String stringInput) {
        if (ActionWordUtil.isNumber(stringInput)) {
            return stringInput;
        }
        return ActionWordUtil.wrapWithDoubleQuotes(stringInput);
    }

    public static String wrapWithDoubleQuotes(String input) {
        return "\"" + input + "\"";
    }

    public static boolean isAlphaNumericOrDashOrUnderscoreOrPointOrCommaOrSpaceChar(String currentChar) {
        return currentChar.matches("[\\w-.,\\s]");
    }

    public static boolean hasSameToken(String name1, String name2, boolean tokenCaseInsensitivity) {
        String replaceParamInName1 = name1.replaceAll("\"[^\"]*\"", "\"");
        String replaceParamInName2 = name2.replaceAll("\"[^\"]*\"", "\"");
        if (tokenCaseInsensitivity) {
            return replaceParamInName1.toLowerCase(Locale.ROOT).equals(replaceParamInName2.toLowerCase(Locale.ROOT));
        }
        return replaceParamInName1.equals(replaceParamInName2);
    }

    public static String generateTestCaseParameter(String valueStr) {
        String removedEqual = valueStr.substring(1, valueStr.length() - 1);
        String replacedSpacesWithUnderscores = removedEqual.trim().replaceAll("(\\s)+", "_");
        return replacedSpacesWithUnderscores.replaceAll("[^\\w-]", "_");
    }

    public static boolean isEscapableCharacter(char c) {
        return ESCAPABLE_CHARS.contains(Character.valueOf(c));
    }

    public static String removeEscapeCharacters(String input) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char nextChar;
            boolean isEscapeChar;
            char c = input.charAt(i);
            boolean isLastChar = i == input.length() - 1;
            boolean bl = isEscapeChar = c == '\\';
            if (!isEscapeChar) {
                result.append(c);
            } else if (!isLastChar && (nextChar = input.charAt(i + 1)) == '\\') {
                result.append('\\');
            }
            ++i;
        }
        return result.toString();
    }

    public static String substituteBracketsWithSquareBrackets(String paramValue) {
        return paramValue.replaceAll("(?<!\\\\)<", "[").replaceAll("(?<!\\\\)>", "]");
    }
}

