/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bdd;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.actionword.ActionWordFragmentVisitor;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.exception.actionword.InvalidActionWordTextException;

@Entity
@Table(name="ACTION_WORD_TEXT")
@PrimaryKeyJoinColumn(name="ACTION_WORD_FRAGMENT_ID")
public class ActionWordText
extends ActionWordFragment {
    @NotNull
    @Column(name="TEXT")
    @Size(max=255)
    private @NotNull @Size(max=255) String text;

    public ActionWordText() {
    }

    public ActionWordText(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new InvalidActionWordTextException("Action word text cannot be empty.");
        }
        if (ActionWord.containsUnescapedDoubleQuotes(text)) {
            throw new InvalidActionWordTextException("Action word text cannot contain double quote.");
        }
        if (ActionWord.containsUnescapedOpenAngleBracket(text)) {
            throw new InvalidActionWordTextException("Action word text cannot contain '<' symbol.");
        }
        if (ActionWord.containsUnescapedCloseAngleBracket(text)) {
            throw new InvalidActionWordTextException("Action word text cannot contain '>' symbol.");
        }
        if (text.length() > 255) {
            throw new InvalidActionWordTextException("Action word text length cannot exceed 255 characters.");
        }
        this.text = ActionWordUtil.replaceExtraSpacesInText(text);
    }

    @Override
    public void accept(ActionWordFragmentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ActionWordFragment createCopy() {
        ActionWordText copy = new ActionWordText();
        copy.setText(this.text);
        return copy;
    }

    public String getText() {
        return this.text;
    }

    public String getUnescapedText() {
        return ActionWordUtil.removeEscapeCharacters(this.text);
    }

    public void setText(String text) {
        this.text = text;
    }
}

