/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bdd;

import java.util.regex.Matcher;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.actionword.ActionWordFragmentVisitor;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.exception.actionword.InvalidActionWordParameterNameException;

@Entity
@Table(name="ACTION_WORD_PARAMETER")
@PrimaryKeyJoinColumn(name="ACTION_WORD_FRAGMENT_ID")
public class ActionWordParameter
extends ActionWordFragment {
    @NotBlank
    @Column(name="NAME")
    @Size(max=255)
    @Pattern(regexp="^[A-Za-z0-9_-]{1,255}$")
    private @NotBlank @Size(max=255) @Pattern(regexp="^[A-Za-z0-9_-]{1,255}$") String name;
    @NotNull
    @Column(name="DEFAULT_VALUE")
    @Size(max=255)
    private @NotNull @Size(max=255) String defaultValue;

    public ActionWordParameter() {
    }

    public ActionWordParameter(String name, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new InvalidActionWordParameterNameException("Action word parameter name cannot be blank.");
        }
        String trimmedName = name.trim();
        if (trimmedName.length() > 255) {
            throw new InvalidActionWordParameterNameException("Action word parameter name length cannot exceed 255 characters.");
        }
        ActionWordParameter.checkIfParamNameIsValid(trimmedName);
        this.name = trimmedName;
        String trimmedDefaultValue = defaultValue.trim();
        if (ActionWord.containsUnescapedDoubleQuotes(trimmedDefaultValue)) {
            throw new InvalidActionWordParameterNameException("Action word parameter default value cannot contain \", < or >.");
        }
        if (trimmedDefaultValue.length() > 255) {
            throw new InvalidActionWordParameterNameException("Action word parameter default value length cannot exceed 255 characters.");
        }
        this.defaultValue = ActionWordUtil.replaceExtraSpacesInText(trimmedDefaultValue);
    }

    @Override
    public void accept(ActionWordFragmentVisitor visitor) {
        visitor.visit(this);
    }

    public static void checkIfParamNameIsValid(String candidate) {
        if (!ActionWordParameter.isParamNameValid(candidate)) {
            throw new InvalidActionWordParameterNameException("Action word parameter name must contain only alphanumeric, dash or underscore characters.");
        }
    }

    public static boolean isParamNameValid(String candidate) {
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("[^\\w_\\- ]");
        Matcher matcher = pattern.matcher(candidate);
        return !matcher.find();
    }

    @Override
    public ActionWordFragment createCopy() {
        ActionWordParameter copy = new ActionWordParameter();
        copy.setName(this.getName());
        copy.setDefaultValue(this.getDefaultValue());
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

