/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bdd;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.actionword.ActionWordFragmentVisitor;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntityVisitor;
import org.squashtest.tm.domain.actionword.ConsumerForActionWordFragmentVisitor;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordText;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Auditable
public class ActionWord
extends BaseAuditableEntity
implements ActionWordTreeEntity {
    public static final int ACTION_WORD_MAX_LENGTH = 255;
    public static final String ACTION_WORD_TEXT_TOKEN = "T";
    public static final String ACTION_WORD_PARAM_TOKEN = "P";
    public static final String ACTION_WORD_DOUBLE_QUOTE = "\"";
    public static final String ACTION_WORD_OPEN_GUILLEMET = "<";
    public static final String ACTION_WORD_CLOSE_GUILLEMET = ">";
    public static final String ACTION_WORD_UNDERSCORE = "_";
    public static final String UNESCAPED_DOUBLE_QUOTE_PATTERN = "(?<!\\\\)\"";
    public static final String UNESCAPED_OPEN_ANGLE_BRACKET_PATTERN = "(?<!\\\\)<";
    public static final String UNESCAPED_CLOSE_ANGLE_BRACKET_PATTERN = "(?<!\\\\)>";
    private static final String ACTION_WORD_TOKEN_TEXT_SEPARATOR = "-";
    @Id
    @Column(name="ACTION_WORD_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="action_word_action_word_id_seq")
    @SequenceGenerator(name="action_word_action_word_id_seq", sequenceName="action_word_action_word_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Column(name="TOKEN")
    private String token;
    @NotNull
    @OneToMany(mappedBy="actionWord", cascade={CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.MERGE, CascadeType.DETACH})
    private Set<KeywordTestStep> keywordTestSteps = new HashSet<KeywordTestStep>(0);
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="FRAGMENT_ORDER")
    @JoinColumn(name="ACTION_WORD_ID")
    private List<ActionWordFragment> fragments = new ArrayList<ActionWordFragment>();
    @Lob
    @Column(name="DESCRIPTION")
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @JoinColumn(name="PROJECT_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @Enumerated(value=EnumType.STRING)
    @Column(name="LAST_IMPLEMENTATION_TECHNOLOGY")
    private BddImplementationTechnology lastImplementationTechnology;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LAST_IMPLEMENTATION_DATE")
    private Date lastImplementationDate;

    public ActionWord() {
    }

    public ActionWord(List<ActionWordFragment> fragments) {
        this.setFragments(fragments);
        this.setToken(this.generateToken());
    }

    public String createWord() {
        StringBuilder builder = new StringBuilder();
        Consumer<ActionWordParameter> consumer = parameter -> {
            StringBuilder stringBuilder2 = builder.append(ACTION_WORD_DOUBLE_QUOTE).append(parameter.getName()).append(ACTION_WORD_DOUBLE_QUOTE);
        };
        ConsumerForActionWordFragmentVisitor visitor = new ConsumerForActionWordFragmentVisitor(consumer, builder);
        for (ActionWordFragment fragment : this.fragments) {
            fragment.accept(visitor);
        }
        return builder.toString();
    }

    public String createWordWithDefaultValues() {
        StringBuilder builder = new StringBuilder();
        Consumer<ActionWordParameter> consumer = parameter -> this.addParamDefaultValueToBuilder(builder, (ActionWordParameter)parameter);
        ConsumerForActionWordFragmentVisitor visitor = new ConsumerForActionWordFragmentVisitor(consumer, builder);
        for (ActionWordFragment fragment : this.fragments) {
            fragment.accept(visitor);
        }
        return builder.toString();
    }

    private void addParamDefaultValueToBuilder(StringBuilder builder, ActionWordParameter parameter) {
        builder.append(ACTION_WORD_DOUBLE_QUOTE);
        String paramDefaultValue = parameter.getDefaultValue();
        if ("".equals(paramDefaultValue)) {
            String paramName = parameter.getName();
            builder.append(paramName);
        } else {
            builder.append(paramDefaultValue);
        }
        builder.append(ACTION_WORD_DOUBLE_QUOTE);
    }

    public String generateToken() {
        final StringBuilder prefixTokenBuilder = new StringBuilder();
        final StringBuilder textTokenBuilder = new StringBuilder(ACTION_WORD_TOKEN_TEXT_SEPARATOR);
        ActionWordFragmentVisitor visitor = new ActionWordFragmentVisitor(){

            @Override
            public void visit(ActionWordText text) {
                prefixTokenBuilder.append(ActionWord.ACTION_WORD_TEXT_TOKEN);
                textTokenBuilder.append(text.getText()).append(ActionWord.ACTION_WORD_TOKEN_TEXT_SEPARATOR);
            }

            @Override
            public void visit(ActionWordParameter parameter) {
                prefixTokenBuilder.append(ActionWord.ACTION_WORD_PARAM_TOKEN);
            }
        };
        for (ActionWordFragment fragment : this.fragments) {
            fragment.accept(visitor);
        }
        return prefixTokenBuilder.append((CharSequence)textTokenBuilder).toString();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Set<KeywordTestStep> getKeywordTestSteps() {
        return this.keywordTestSteps;
    }

    public void setKeywordTestSteps(Set<KeywordTestStep> keywordTestSteps) {
        this.keywordTestSteps = keywordTestSteps;
    }

    public void addStep(KeywordTestStep keywordTestStep) {
        this.keywordTestSteps.add(keywordTestStep);
    }

    public List<ActionWordParameter> getActionWordParams() {
        final ArrayList<ActionWordParameter> result = new ArrayList<ActionWordParameter>();
        ActionWordFragmentVisitor visitor = new ActionWordFragmentVisitor(){

            @Override
            public void visit(ActionWordText text) {
            }

            @Override
            public void visit(ActionWordParameter parameter) {
                result.add(parameter);
            }
        };
        for (ActionWordFragment fragment : this.getFragments()) {
            fragment.accept(visitor);
        }
        return result;
    }

    public List<ActionWordText> getActionWordTexts() {
        final ArrayList<ActionWordText> result = new ArrayList<ActionWordText>();
        ActionWordFragmentVisitor visitor = new ActionWordFragmentVisitor(){

            @Override
            public void visit(ActionWordText text) {
                result.add(text);
            }

            @Override
            public void visit(ActionWordParameter parameter) {
            }
        };
        for (ActionWordFragment fragment : this.getFragments()) {
            fragment.accept(visitor);
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @AclConstrainedObject
    public ActionWordLibrary getActionWordLibrary() {
        return this.project.getActionWordLibrary();
    }

    public List<ActionWordFragment> getFragments() {
        return this.fragments;
    }

    public void setFragments(List<ActionWordFragment> fragments) {
        this.fragments = fragments;
    }

    public void addFragment(@NotNull ActionWordFragment fragment) {
        ActionWordFragment actionWordFragment = fragment;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)actionWordFragment);
        this.getFragments().add(fragment);
    }

    @Override
    public void accept(ActionWordTreeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ActionWordTreeEntity createCopy() {
        List<ActionWordFragment> fragmentsCopy = this.copyFragments();
        ActionWord copy = new ActionWord(fragmentsCopy);
        fragmentsCopy.stream().forEach(fragment -> fragment.setActionWord(copy));
        copy.setDescription(this.getDescription());
        copy.setProject(this.getProject());
        return copy;
    }

    private List<ActionWordFragment> copyFragments() {
        return this.getFragments().stream().map(ActionWordFragment::createCopy).collect(Collectors.toList());
    }

    public static boolean containsUnescapedDoubleQuotes(String input) {
        Pattern pattern = Pattern.compile(UNESCAPED_DOUBLE_QUOTE_PATTERN);
        return pattern.matcher(input).find();
    }

    public static boolean containsUnescapedOpenAngleBracket(String input) {
        Pattern pattern = Pattern.compile(UNESCAPED_OPEN_ANGLE_BRACKET_PATTERN);
        return pattern.matcher(input).find();
    }

    public static boolean containsUnescapedCloseAngleBracket(String input) {
        Pattern pattern = Pattern.compile(UNESCAPED_CLOSE_ANGLE_BRACKET_PATTERN);
        return pattern.matcher(input).find();
    }

    @Override
    public String getName() {
        return this.createWord();
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }
}

