/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.attachment;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;

@Entity
public class AttachmentList
implements Identified {
    @Id
    @Column(name="ATTACHMENT_LIST_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="attachment_list_attachment_list_id_seq")
    @SequenceGenerator(name="attachment_list_attachment_list_id_seq", sequenceName="attachment_list_attachment_list_id_seq", allocationSize=1)
    private Long id;
    @OneToMany(mappedBy="attachmentList", cascade={CascadeType.ALL})
    private final Set<Attachment> attachments = new HashSet<Attachment>();

    @Override
    public Long getId() {
        return this.id;
    }

    public void addAttachment(Attachment attachment) {
        attachment.setAttachmentList(this);
        this.attachments.add(attachment);
    }

    public void removeAttachment(Attachment attachment) {
        this.removeAttachment(attachment.getId());
    }

    public void removeAttachment(long attachmentId) {
        Iterator<Attachment> iter = this.attachments.iterator();
        while (iter.hasNext()) {
            Attachment at = iter.next();
            if (at.getId() != attachmentId) continue;
            iter.remove();
            break;
        }
    }

    public Attachment getAttachmentById(long attachmentId) {
        Attachment result = null;
        for (Attachment at : this.attachments) {
            if (at.getId() != attachmentId) continue;
            result = at;
            break;
        }
        return result;
    }

    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.hasAttachments();
    }

    public Set<Attachment> getAllAttachments() {
        return this.attachments;
    }

    public int size() {
        return this.getAllAttachments().size();
    }
}

