/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.actionword;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntityVisitor;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.tree.GenericTreeLibrary;

@Entity
public class ActionWordLibrary
extends GenericTreeLibrary
implements ActionWordTreeEntity {
    private static final String CLASS_NAME = "org.squashtest.tm.domain.actionword.ActionWordLibrary";
    private static final String SIMPLE_CLASS_NAME = "ActionWordLibrary";
    @Id
    @Column(name="AWL_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="action_word_library_awl_id_seq")
    @SequenceGenerator(name="action_word_library_awl_id_seq", sequenceName="action_word_library_awl_id_seq", allocationSize=1)
    private Long id;
    @OneToOne(mappedBy="actionWordLibrary")
    private GenericProject project;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Project getProject() {
        return (Project)this.project;
    }

    @Override
    public void accept(ActionWordTreeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ActionWordTreeEntity createCopy() {
        throw new UnsupportedOperationException("Cannot copy a library.");
    }

    @Override
    public void notifyAssociatedWithProject(GenericProject project) {
        this.project = project;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setProject(Project project) {
        throw new UnsupportedOperationException("A library cannot be renamed. Please rename the project instead.");
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.ACTION_WORD_LIBRARY, this.id);
    }

    @Override
    public String getClassSimpleName() {
        return SIMPLE_CLASS_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }
}

