/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.exception.customfield.StringDoesNotMatchesPatternException;

public class EntityReference {
    @Enumerated(value=EnumType.STRING)
    private EntityType type;
    private Long id;

    private EntityReference() {
    }

    public EntityReference(EntityType entityType, Long entityId) {
        this.type = entityType;
        this.id = entityId;
        Assert.parameterNotNull((Object)((Object)entityType), (String)"entityType");
        Assert.parameterNotNull((Object)entityId, (String)"entityId");
    }

    public EntityType getType() {
        return this.type;
    }

    public Long getId() {
        return this.id;
    }

    public String toString() {
        return "[" + this.type.toString() + ":" + this.id + "]";
    }

    public String toNodeId() {
        return String.valueOf(this.type.getSimpleClassName()) + "-" + this.id;
    }

    public static List<String> toNodeIds(Collection<EntityReference> entityReferences) {
        return entityReferences.stream().map(EntityReference::toNodeId).collect(Collectors.toList());
    }

    public static EntityReference fromNodeId(String asString) throws StringDoesNotMatchesPatternException, IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)asString)) {
            throw new IllegalArgumentException("Entity reference id as String should not be blank");
        }
        Pattern p = Pattern.compile("([A-Za-z]*)-(-*\\d+)");
        Matcher m = p.matcher(asString);
        if (m.matches()) {
            String type = m.group(1);
            Long id = Long.valueOf(m.group(2));
            EntityType etype = EntityType.fromSimpleName(type);
            return new EntityReference(etype, id);
        }
        throw new StringDoesNotMatchesPatternException();
    }

    public int hashCode() {
        int result = 29;
        result = 43 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 43 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityReference other = (EntityReference)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.type == other.type;
    }

    public NodeReference toNodeReference() {
        NodeType nodeType = this.type.toNodeType();
        return new NodeReference(nodeType, this.id);
    }
}

