/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.security.acls;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.AuditableAccessControlEntry;
import org.springframework.util.Assert;

public class Slf4jAuditLogger
implements AuditLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(Slf4jAuditLogger.class);

    public void logIfNeeded(boolean granted, AccessControlEntry ace) {
        if (LOGGER.isDebugEnabled()) {
            Assert.notNull((Object)ace, (String)"AccessControlEntry required");
            this.logIfPossible(granted, ace);
        }
    }

    private void logIfPossible(boolean granted, AccessControlEntry ace) {
        if (ace instanceof AuditableAccessControlEntry) {
            AuditableAccessControlEntry auditableAce = (AuditableAccessControlEntry)ace;
            this.logRelevantInformation(granted, auditableAce);
        }
    }

    private void logRelevantInformation(boolean granted, AuditableAccessControlEntry auditableAce) {
        if (granted && auditableAce.isAuditSuccess()) {
            LOGGER.debug("GRANTED due to ACE: " + auditableAce);
        } else if (!granted && auditableAce.isAuditFailure()) {
            LOGGER.debug("DENIED due to ACE: " + auditableAce);
        }
    }
}

