/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.records.ResourceRecord;

public class Resource
extends TableImpl<ResourceRecord> {
    private static final long serialVersionUID = -511513955L;
    public static final Resource RESOURCE = new Resource();
    public final TableField<ResourceRecord, Long> RES_ID = Resource.createField((String)"RES_ID", (DataType)SQLDataType.BIGINT.nullable(false).identity(true), (Table)this, (String)"");
    public final TableField<ResourceRecord, String> NAME = Resource.createField((String)"NAME", (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<ResourceRecord, String> DESCRIPTION = Resource.createField((String)"DESCRIPTION", (DataType)SQLDataType.VARCHAR((int)Integer.MAX_VALUE).defaultValue(DSL.field((String)"NULL", (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"");
    public final TableField<ResourceRecord, String> CREATED_BY = Resource.createField((String)"CREATED_BY", (DataType)SQLDataType.VARCHAR((int)50).nullable(false), (Table)this, (String)"");
    public final TableField<ResourceRecord, Timestamp> CREATED_ON = Resource.createField((String)"CREATED_ON", (DataType)SQLDataType.TIMESTAMP.nullable(false), (Table)this, (String)"");
    public final TableField<ResourceRecord, String> LAST_MODIFIED_BY = Resource.createField((String)"LAST_MODIFIED_BY", (DataType)SQLDataType.VARCHAR((int)50).defaultValue(DSL.field((String)"NULL", (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"");
    public final TableField<ResourceRecord, Timestamp> LAST_MODIFIED_ON = Resource.createField((String)"LAST_MODIFIED_ON", (DataType)SQLDataType.TIMESTAMP.defaultValue(DSL.field((String)"NULL", (DataType)SQLDataType.TIMESTAMP)), (Table)this, (String)"");
    public final TableField<ResourceRecord, Long> ATTACHMENT_LIST_ID = Resource.createField((String)"ATTACHMENT_LIST_ID", (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"");

    public Class<ResourceRecord> getRecordType() {
        return ResourceRecord.class;
    }

    public Resource() {
        this(DSL.name((String)"RESOURCE"), null);
    }

    public Resource(String alias) {
        this(DSL.name((String)alias), (Table<ResourceRecord>)RESOURCE);
    }

    public Resource(Name alias) {
        this(alias, (Table<ResourceRecord>)RESOURCE);
    }

    private Resource(Name alias, Table<ResourceRecord> aliased) {
        this(alias, aliased, null);
    }

    private Resource(Name alias, Table<ResourceRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, "");
    }

    public Schema getSchema() {
        return Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.FK_RESOURCE_ATTACHMENT_LIST_INDEX_B, Indexes.IDX_RESOURCE_CREATED_BY, Indexes.IDX_RESOURCE_LAST_MODIFIED_BY, Indexes.IDX_RESOURCE_NAME, Indexes.PRIMARY_KEY_BD);
    }

    public Identity<ResourceRecord, Long> getIdentity() {
        return Keys.IDENTITY_RESOURCE;
    }

    public UniqueKey<ResourceRecord> getPrimaryKey() {
        return Keys.CONSTRAINT_1A;
    }

    public List<UniqueKey<ResourceRecord>> getKeys() {
        return Arrays.asList(Keys.CONSTRAINT_1A);
    }

    public List<ForeignKey<ResourceRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_RESOURCE_ATTACHMENT_LIST);
    }

    public Resource as(String alias) {
        return new Resource(DSL.name((String)alias), (Table<ResourceRecord>)this);
    }

    public Resource as(Name alias) {
        return new Resource(alias, (Table<ResourceRecord>)this);
    }

    public Resource rename(String name) {
        return new Resource(DSL.name((String)name), null);
    }

    public Resource rename(Name name) {
        return new Resource(name, null);
    }
}

