/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.records.IssueRecord;

public class Issue
extends TableImpl<IssueRecord> {
    private static final long serialVersionUID = 1302017038L;
    public static final Issue ISSUE = new Issue();
    public final TableField<IssueRecord, Long> ISSUE_ID = Issue.createField((String)"ISSUE_ID", (DataType)SQLDataType.BIGINT.nullable(false).identity(true), (Table)this, (String)"");
    public final TableField<IssueRecord, String> REMOTE_ISSUE_ID = Issue.createField((String)"REMOTE_ISSUE_ID", (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<IssueRecord, Long> ISSUE_LIST_ID = Issue.createField((String)"ISSUE_LIST_ID", (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"");
    public final TableField<IssueRecord, Long> BUGTRACKER_ID = Issue.createField((String)"BUGTRACKER_ID", (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"");
    public final TableField<IssueRecord, String> ADDITIONAL_DATA = Issue.createField((String)"ADDITIONAL_DATA", (DataType)SQLDataType.VARCHAR((int)Integer.MAX_VALUE), (Table)this, (String)"");

    public Class<IssueRecord> getRecordType() {
        return IssueRecord.class;
    }

    public Issue() {
        this(DSL.name((String)"ISSUE"), null);
    }

    public Issue(String alias) {
        this(DSL.name((String)alias), (Table<IssueRecord>)ISSUE);
    }

    public Issue(Name alias) {
        this(alias, (Table<IssueRecord>)ISSUE);
    }

    private Issue(Name alias, Table<IssueRecord> aliased) {
        this(alias, aliased, null);
    }

    private Issue(Name alias, Table<IssueRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, "");
    }

    public Schema getSchema() {
        return Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.FK_ISSUE_BUGTRACKER_INDEX_6, Indexes.FK_ISSUE_ISSUE_LIST_INDEX_6, Indexes.IDX_ISSUE, Indexes.ISSUE_REMOTE_ISSUE_ID_IDX, Indexes.PRIMARY_KEY_64);
    }

    public Identity<IssueRecord, Long> getIdentity() {
        return Keys.IDENTITY_ISSUE;
    }

    public UniqueKey<IssueRecord> getPrimaryKey() {
        return Keys.CONSTRAINT_42;
    }

    public List<UniqueKey<IssueRecord>> getKeys() {
        return Arrays.asList(Keys.CONSTRAINT_42);
    }

    public List<ForeignKey<IssueRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ISSUE_ISSUE_LIST, Keys.FK_ISSUE_BUGTRACKER);
    }

    public Issue as(String alias) {
        return new Issue(DSL.name((String)alias), (Table<IssueRecord>)this);
    }

    public Issue as(Name alias) {
        return new Issue(alias, (Table<IssueRecord>)this);
    }

    public Issue rename(String name) {
        return new Issue(DSL.name((String)name), null);
    }

    public Issue rename(Name name) {
        return new Issue(name, null);
    }
}

