/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.infrastructure.hibernate;

import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;

public class ExecutionPersister
extends JoinedSubclassEntityPersister {
    private static final String NONFORMATTED_TABLE_NAME = "ITEM_TEST_PLAN_EXECUTION";
    private static final String NONFORMATTED_COLUMN_NAME = "EXECUTION_ID";
    private static final String ERROR_MESSAGE_JOIN_TABLE_NOT_FOUND = "ExecutionPersister : could not find the join table ITEM_TEST_PLAN_EXECUTION";
    private String formattedTableName;
    private String[] formattedColumnName = new String[1];
    private int cachedIndex = -1;

    public ExecutionPersister(PersistentClass persistentClass, EntityRegionAccessStrategy cacheAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        this.init(persistentClass, creationContext.getSessionFactory());
    }

    protected String[] getSubclassTableKeyColumns(int j) {
        if (this.isTheJoinTable(j)) {
            return this.formattedColumnName;
        }
        return super.getSubclassTableKeyColumns(j);
    }

    private boolean isTheJoinTable(int index) {
        if (this.cachedIndex == -1) {
            boolean isTheOne = this.getSubclassTableName(index).equals(this.formattedTableName);
            if (isTheOne) {
                this.cachedIndex = index;
            }
            return isTheOne;
        }
        return this.cachedIndex == index;
    }

    protected boolean isInverseTable(int j) {
        if (this.isTheJoinTable(j)) {
            return true;
        }
        return super.isInverseTable(j);
    }

    private void init(PersistentClass persistentClass, SessionFactoryImplementor factory) {
        this.createTableNamePattern(persistentClass, factory);
        this.createColumnName(factory);
    }

    private void createTableNamePattern(PersistentClass persistentClass, SessionFactoryImplementor factory) {
        Iterator joinIterator = persistentClass.getJoinClosureIterator();
        while (joinIterator.hasNext()) {
            Table table = ((Join)joinIterator.next()).getTable();
            if (!NONFORMATTED_TABLE_NAME.equalsIgnoreCase(table.getName())) continue;
            this.formattedTableName = table.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            return;
        }
        throw new IllegalArgumentException(ERROR_MESSAGE_JOIN_TABLE_NOT_FOUND);
    }

    private void createColumnName(SessionFactoryImplementor factory) {
        Column column = new Column(NONFORMATTED_COLUMN_NAME);
        this.formattedColumnName[0] = column.getQuotedName(factory.getDialect());
    }
}

