/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.Team;

@Entity
@Auditable
@Table(name="CORE_USER")
@PrimaryKeyJoinColumn(name="PARTY_ID")
public class User
extends Party
implements AuditableMixin {
    private static final String TYPE = "USER";
    @Transient
    public static final Long NO_USER_ID = 0L;
    @NotNull
    @Size(min=0, max=50)
    private @NotNull @Size(min=0, max=50) String firstName;
    @NotBlank
    @Size(min=0, max=50)
    private @NotBlank @Size(min=0, max=50) String lastName;
    @NotBlank
    @Size(min=0, max=50)
    private @NotBlank @Size(min=0, max=50) String login;
    @NotNull
    @Size(min=0, max=255)
    private @NotNull @Size(min=0, max=255) String email;
    private Boolean active;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastConnectedOn;
    @NotNull
    @ManyToMany(mappedBy="members")
    private final Set<Team> teams;
    @Transient
    public AuditableSupport audit;

    public User() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.firstName = "";
        this.email = "";
        this.active = true;
        this.teams = new HashSet<Team>();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login.trim();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setLastConnectedOn(Date lastConnectedOn) {
        this.lastConnectedOn = lastConnectedOn;
    }

    public Date getLastConnectedOn() {
        return this.lastConnectedOn;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    public void addTeam(Team team) {
        this.teams.add(team);
    }

    public void removeTeams(Collection<Long> teamIds) {
        Iterator<Team> iterator = this.teams.iterator();
        while (iterator.hasNext()) {
            Team team = iterator.next();
            if (!teamIds.contains(team.getId())) continue;
            team.removeMember(this);
            iterator.remove();
        }
    }

    @Override
    public String getName() {
        return this.appendFullName(new StringBuilder()).append(" (").append(this.login).append(")").toString();
    }

    private StringBuilder appendFullName(StringBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)this.firstName)) {
            builder.append(this.firstName).append(' ');
        }
        builder.append(this.lastName);
        return builder;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void accept(PartyVisitor visitor) {
        visitor.visit(this);
    }

    public static User createFromLogin(@NotNull String login) {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        User user = new User();
        user.login = login;
        user.normalize();
        return user;
    }

    public boolean loginIs(String candidate) {
        return StringUtils.equals((CharSequence)this.login, (CharSequence)candidate);
    }

    public void normalize() {
        if (StringUtils.isBlank((CharSequence)this.lastName)) {
            this.lastName = this.login;
        }
        this.firstName = this.firstName != null ? this.firstName : "";
        this.email = this.email != null ? this.email : "";
        this.active = this.active != null ? this.active : true;
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

