/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.tf.automationrequest;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Table(name="AUTOMATION_REQUEST")
public class AutomationRequest
implements Identified {
    @Id
    @Column(name="AUTOMATION_REQUEST_ID")
    @GeneratedValue(generator="automation_request_automation_request_id_seq", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="automation_request_automation_request_id_seq", sequenceName="automation_request_automation_request_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="REQUEST_STATUS")
    private AutomationRequestStatus requestStatus = AutomationRequestStatus.WORK_IN_PROGRESS;
    @Column(name="TRANSMITTED_ON")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date transmissionDate;
    @ManyToOne
    @JoinColumn(name="ASSIGNED_TO")
    private User assignedTo;
    @Column(name="AUTOMATION_PRIORITY")
    private Integer automationPriority;
    @Column(name="ASSIGNED_ON")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date assignmentDate;
    @NotNull
    @OneToOne(optional=false)
    @JoinColumn(name="TEST_CASE_ID")
    private TestCase testCase;
    @ManyToOne
    @JoinColumn(name="CREATED_BY")
    private User createdBy;
    @ManyToOne
    @JoinColumn(name="TRANSMITTED_BY")
    private User transmittedBy;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @Column(name="CONFLICT_ASSOCIATION")
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String conflictAssociation = "";
    @Column(name="IS_MANUAL")
    private boolean isManual;
    @OneToOne(mappedBy="automationRequest", optional=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private RemoteAutomationRequestExtender remoteAutomationRequestExtender;

    public String getConflictAssociation() {
        if (this.conflictAssociation == null) {
            return "";
        }
        return this.conflictAssociation;
    }

    public void setConflictAssociation(String conflictAssociation) {
        this.conflictAssociation = conflictAssociation;
    }

    public boolean isManual() {
        return this.isManual;
    }

    public void setManual(boolean manual) {
        this.isManual = manual;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AutomationRequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(AutomationRequestStatus requestStatus) {
        this.requestStatus = requestStatus;
    }

    public Date getTransmissionDate() {
        return this.transmissionDate;
    }

    public void setTransmissionDate(Date transmissionDate) {
        this.transmissionDate = transmissionDate;
    }

    public User getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(User assignedTo) {
        this.assignedTo = assignedTo;
    }

    public Integer getAutomationPriority() {
        return this.automationPriority;
    }

    public void setAutomationPriority(Integer automationPriority) {
        this.automationPriority = automationPriority;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public Date getAssignmentDate() {
        return this.assignmentDate;
    }

    public void setAssignmentDate(Date assignmentDate) {
        this.assignmentDate = assignmentDate;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public User getTransmittedBy() {
        return this.transmittedBy;
    }

    public void setTransmittedBy(User transmittedBy) {
        this.transmittedBy = transmittedBy;
    }

    public RemoteAutomationRequestExtender getRemoteAutomationRequestExtender() {
        return this.remoteAutomationRequestExtender;
    }

    public void setRemoteAutomationRequestExtender(RemoteAutomationRequestExtender remoteAutomationRequestExtender) {
        this.remoteAutomationRequestExtender = remoteAutomationRequestExtender;
    }

    public Project getProject() {
        return this.project;
    }

    public void notifyAssociatedWithProject(Project project) {
        this.project = project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @AclConstrainedObject
    public AutomationRequestLibrary getLibrary() {
        return this.project.getAutomationRequestLibrary();
    }
}

