/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Persister;
import org.springframework.context.MessageSource;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.Referenceable;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.infrastructure.hibernate.TestStepPersister;
import org.squashtest.tm.security.annotation.AclConstrainedObject;
import org.squashtest.tm.security.annotation.InheritsAcls;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@InheritsAcls(constrainedClass=TestCase.class, collectionName="steps")
@Persister(impl=TestStepPersister.class)
public abstract class TestStep
implements Identified,
RelatedToAuditable,
Referenceable {
    @Id
    @Column(name="TEST_STEP_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="test_step_test_step_id_seq")
    @SequenceGenerator(name="test_step_test_step_id_seq", sequenceName="test_step_test_step_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="TEST_CASE_STEPS", joinColumns={@JoinColumn(name="STEP_ID", updatable=false, insertable=false)}, inverseJoinColumns={@JoinColumn(name="TEST_CASE_ID", updatable=false, insertable=false)})
    private TestCase testCase;

    @Override
    public Long getId() {
        return this.id;
    }

    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        this.testCase = testCase;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    @AclConstrainedObject
    public TestCaseLibrary getLibrary() {
        if (this.testCase != null) {
            return (TestCaseLibrary)this.testCase.getLibrary();
        }
        return null;
    }

    public int getIndex() {
        int result = -1;
        if (this.testCase != null) {
            result = this.testCase.getPositionOfStep(this.id);
        }
        return result;
    }

    public abstract TestStep createCopy();

    public abstract void accept(TestStepVisitor var1);

    public abstract List<ExecutionStep> createExecutionSteps(Dataset var1, MessageSource var2, Locale var3);

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return Collections.singletonList(this.testCase);
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.TEST_STEP, this.id);
    }
}

