/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.Objects;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;

public enum TestCaseKind implements Internationalizable
{
    STANDARD,
    GHERKIN,
    KEYWORD;


    public boolean isScripted() {
        return this.equals((Object)GHERKIN);
    }

    public String getI18nKey() {
        return "test-case.format." + this.name().toLowerCase();
    }

    public static TestCaseKind fromLeftJoinIds(Long scriptedTestCaseId, Long keywordTestCaseId) {
        boolean isGherkin = Objects.nonNull(scriptedTestCaseId);
        boolean isKeyword = Objects.nonNull(keywordTestCaseId);
        if (isGherkin) {
            return GHERKIN;
        }
        if (isKeyword) {
            return KEYWORD;
        }
        return STANDARD;
    }

    public static TestCaseKind fromTestCase(TestCase testCase) {
        final TestCaseKind[] testCaseKind = new TestCaseKind[1];
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(){

            @Override
            public void visit(TestCase testCase) {
                testCaseKind[0] = STANDARD;
            }

            @Override
            public void visit(KeywordTestCase keywordTestCase) {
                testCaseKind[0] = KEYWORD;
            }

            @Override
            public void visit(ScriptedTestCase scriptedTestCase) {
                testCaseKind[0] = GHERKIN;
            }
        };
        testCase.accept(testCaseVisitor);
        return testCaseKind[0];
    }
}

