/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PrimaryKeyJoinColumn;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;

@Entity
@PrimaryKeyJoinColumn(name="TCLN_ID")
public class ScriptedTestCase
extends TestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptedTestCase.class);
    public static final String LANGUAGE_TAG = "# language: ";
    public static final String FEATURE_EXTENSION = "feature";
    private static final String ILLEGAL_PATTERN = "[^a-zA-Z0-9\\_\\-]";
    public static final int FILENAME_MAX_SIZE = 100;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String script = "";

    public ScriptedTestCase() {
    }

    public ScriptedTestCase(String name) {
        this.setName(name);
        this.populateInitialScript(LocaleContextHolder.getLocale().getLanguage());
    }

    public void populateInitialScript(String locale) {
        LOGGER.info("Try to populate script with script language {} and locale {}.", (Object)locale);
        StringBuilder sb = new StringBuilder();
        sb.append(LANGUAGE_TAG).append(locale).append("\n");
        GherkinDialectProvider gherkinDialectProvider = new GherkinDialectProvider(locale);
        GherkinDialect defaultDialect = gherkinDialectProvider.getDefaultDialect();
        String featureKeyword = (String)defaultDialect.getFeatureKeywords().get(0);
        sb.append(featureKeyword).append(": ").append(this.getName());
        this.setScript(sb.toString());
    }

    @Override
    public ScriptedTestCase createCopy() {
        ScriptedTestCase copy = new ScriptedTestCase();
        this.populateCopiedTestCaseAttributes(copy);
        copy.setScript(this.getScript());
        return copy;
    }

    public String computeScriptWithAppendedMetadata() {
        StringBuilder sb = new StringBuilder(this.script);
        sb.insert(0, "# Test case importance: " + this.getImportance() + "\n");
        sb.insert(0, "# Automation priority: " + this.getAutomationRequest().getAutomationPriority() + "\n");
        return sb.toString();
    }

    public static ScriptedTestCase createBlankScriptedTestCase(String script) {
        ScriptedTestCase res = new ScriptedTestCase();
        ScriptedTestCase.setAttributesAsNullForBlankTestCase(res);
        res.script = script;
        return res;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    protected boolean isAutomatedInWorkflow() {
        return this.isActuallyAutomated() && TestCaseAutomatable.Y.equals(this.automatable) && AutomationRequestStatus.AUTOMATED.equals(this.automationRequest.getRequestStatus()) && this.getProject().getScmRepository() != null;
    }

    @Override
    public void accept(TestCaseVisitor visitor) {
        visitor.visit(this);
    }

    public String createFilename() {
        String normalized = this.baseNameFromTestCase();
        String caped = StringUtils.substring((String)normalized, (int)0, (int)(100 - (FEATURE_EXTENSION.length() + 1)));
        return String.valueOf(caped) + "." + FEATURE_EXTENSION;
    }

    private String baseNameFromTestCase() {
        String name = this.getName();
        Long id = this.getId();
        String deAccented = StringUtils.stripAccents((String)name);
        String normalized = deAccented.replaceAll(ILLEGAL_PATTERN, "_");
        return id + "_" + normalized;
    }

    public String buildFilenameMatchPattern() {
        return String.format("%d(_.*)?\\.%s", this.getId(), FEATURE_EXTENSION);
    }

    public String createBackupFileName() {
        return this.getId() + "." + FEATURE_EXTENSION;
    }
}

