/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.library.ExportData;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.ExportTestStepData;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;

public class ExportTestCaseData
extends ExportData
implements TestStepVisitor {
    private String prerequisite = "";
    private TestCaseImportance weight;
    private String reference = "";
    private String nature;
    private String type;
    private TestCaseStatus status;
    private String firstAction = "";
    private String firstExpectedResult = "";
    private List<ExportTestStepData> steps = new ArrayList<ExportTestStepData>();
    private ExportTestStepData lastBuildStepData;
    private String lastModifiedBy = "";
    private Date lastModifiedOn;
    private String uuid;

    public ExportTestCaseData() {
    }

    public ExportTestCaseData(TestCase testCase, TestCaseFolder folder) {
        super(testCase, folder);
        this.doSetReference(testCase.getReference());
        this.doSetPrerequisite(testCase.getPrerequisite());
        this.weight = testCase.getImportance();
        this.nature = testCase.getNature().getCode();
        this.type = testCase.getType().getCode();
        this.status = testCase.getStatus();
        TestCase audit = testCase;
        this.lastModifiedBy = AuditableMixinAspect.ajc$interMethodDispatch1$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(audit);
        this.lastModifiedOn = AuditableMixinAspect.ajc$interMethodDispatch1$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(audit);
        this.uuid = testCase.getUuid();
        this.formatSteps(testCase);
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String prerequisite) {
        this.doSetPrerequisite(prerequisite);
    }

    private void doSetPrerequisite(String prerequisite) {
        if (prerequisite != null) {
            this.prerequisite = prerequisite;
        }
    }

    public TestCaseImportance getWeight() {
        return this.weight;
    }

    public void setWeight(TestCaseImportance weight) {
        this.weight = weight;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.doSetReference(reference);
    }

    private void doSetReference(String reference) {
        if (reference != null) {
            this.reference = reference;
        }
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TestCaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestCaseStatus status) {
        this.status = status;
    }

    public String getFirstAction() {
        return this.firstAction;
    }

    public void setFirstAction(String firstAction) {
        this.doSetFirstAction(firstAction);
    }

    private void doSetFirstAction(String firstAction) {
        if (firstAction != null) {
            this.firstAction = firstAction;
        }
    }

    public String getFirstExpectedResult() {
        return this.firstExpectedResult;
    }

    public void setFirstExpectedResult(String firstExpectedResult) {
        this.doSetFirstExpectedResult(firstExpectedResult);
    }

    private void doSetFirstExpectedResult(String firstExpectedResult) {
        if (firstExpectedResult != null) {
            this.firstExpectedResult = firstExpectedResult;
        }
    }

    public List<ExportTestStepData> getSteps() {
        return this.steps;
    }

    public void setSteps(List<ExportTestStepData> steps) {
        this.steps = steps;
    }

    private void formatSteps(TestCase testCase) {
        List<TestStep> testSteps = testCase.getSteps();
        if (!testSteps.isEmpty()) {
            this.formatFirstStepsInfos(testSteps);
            this.formatOtherStepsInfos(testSteps);
        }
    }

    private void formatOtherStepsInfos(List<TestStep> testSteps) {
        int i = 1;
        while (i < testSteps.size()) {
            ExportTestStepData otherStep = this.buildExportTestStepData(testSteps.get(i));
            otherStep.setTestCase(this);
            this.steps.add(otherStep);
            ++i;
        }
    }

    private void formatFirstStepsInfos(List<TestStep> testSteps) {
        ExportTestStepData firstStep = this.buildExportTestStepData(testSteps.get(0));
        firstStep.setTestCase(this);
        this.doSetFirstAction(firstStep.getAction());
        this.doSetFirstExpectedResult(firstStep.getExpectedResult());
    }

    private ExportTestStepData buildExportTestStepData(TestStep item) {
        item.accept(this);
        return this.lastBuildStepData;
    }

    @Override
    public void visit(ActionTestStep visited) {
        String action = visited.getAction();
        String result = visited.getExpectedResult();
        this.lastBuildStepData = new ExportTestStepData(action, result);
    }

    @Override
    public void visit(CallTestStep visited) {
        String action = "Calls : " + visited.getCalledTestCase().getName();
        String result = "";
        this.lastBuildStepData = new ExportTestStepData(action, result);
    }

    @Override
    public void visit(KeywordTestStep visited) {
        throw new UnsupportedOperationException();
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

