/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;

@Entity
public class DatasetParamValue
implements Identified,
RelatedToAuditable {
    @Id
    @Column(name="DATASET_PARAM_VALUE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="dataset_param_value_dataset_param_value_id_seq")
    @SequenceGenerator(name="dataset_param_value_dataset_param_value_id_seq", sequenceName="dataset_param_value_dataset_param_value_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="PARAM_ID", referencedColumnName="PARAM_ID")
    private Parameter parameter;
    @ManyToOne
    @JoinColumn(name="DATASET_ID", referencedColumnName="DATASET_ID")
    private Dataset dataset;
    @NotNull
    @Size(max=1024)
    private @NotNull @Size(max=1024) String paramValue = "";

    public DatasetParamValue() {
    }

    public DatasetParamValue(Parameter parameter, Dataset dataset) {
        this();
        this.parameter = parameter;
        this.dataset = dataset;
        this.dataset.addParameterValue(this);
    }

    public DatasetParamValue(Parameter parameter, Dataset dataset, String paramValue) {
        this(parameter, dataset);
        this.paramValue = paramValue;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return this.parameter.getAssociatedAuditableList();
    }
}

