/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.constraints.NotNull;
import org.springframework.context.MessageSource;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;

@Entity
@PrimaryKeyJoinColumn(name="TEST_STEP_ID")
public class CallTestStep
extends TestStep {
    @ManyToOne(optional=false)
    @JoinColumn(name="CALLED_TEST_CASE_ID")
    private TestCase calledTestCase;
    @ManyToOne
    @JoinColumn(name="CALLED_DATASET")
    private Dataset calledDataset;
    @Column(name="DELEGATE_PARAMETER_VALUES")
    private boolean delegateParameterValues = false;

    @Override
    public CallTestStep createCopy() {
        CallTestStep copy = new CallTestStep();
        copy.calledDataset = this.calledDataset;
        copy.calledTestCase = this.calledTestCase;
        copy.delegateParameterValues = this.isDelegateParameterValues();
        copy.setTestCase(this.getTestCase());
        return copy;
    }

    @Override
    public void accept(TestStepVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(){

            @Override
            public void visit(TestCase testCase) {
            }

            @Override
            public void visit(KeywordTestCase keywordTestCase) {
                throw new IllegalArgumentException("Cannot add a Call Test Step outside a Test Case");
            }

            @Override
            public void visit(ScriptedTestCase scriptedTestCase) {
                throw new IllegalArgumentException("Cannot add a Call Test Step outside a Test Case");
            }
        };
        testCase.accept(testCaseVisitor);
        super.setTestCase(testCase);
    }

    public void setCalledTestCase(TestCase calledTestCase) {
        this.calledTestCase = calledTestCase;
    }

    public TestCase getCalledTestCase() {
        return this.calledTestCase;
    }

    public Dataset getCalledDataset() {
        return this.calledDataset;
    }

    public void setCalledDataset(Dataset calledDataset) {
        if (calledDataset != null && !this.calledTestCase.getDatasets().contains(calledDataset)) {
            throw new IllegalArgumentException("attempted to bind to a call step a dataset that doesn't belong to the called test case");
        }
        this.calledDataset = calledDataset;
    }

    public boolean isDelegateParameterValues() {
        return this.delegateParameterValues;
    }

    public void setDelegateParameterValues(boolean delegateParameterValues) {
        this.delegateParameterValues = delegateParameterValues;
    }

    public ParameterAssignationMode getParameterAssignationMode() {
        if (this.calledDataset != null) {
            return ParameterAssignationMode.CALLED_DATASET;
        }
        if (this.delegateParameterValues) {
            return ParameterAssignationMode.DELEGATE;
        }
        return ParameterAssignationMode.NOTHING;
    }

    @Override
    public List<ExecutionStep> createExecutionSteps(Dataset dataset, MessageSource messageSource, Locale locale) {
        Dataset effective;
        List<TestStep> testSteps = this.getCalledTestCase().getSteps();
        ArrayList<ExecutionStep> returnList = new ArrayList<ExecutionStep>(testSteps.size());
        switch (this.getParameterAssignationMode()) {
            case CALLED_DATASET: {
                effective = this.calledDataset;
                break;
            }
            case DELEGATE: {
                effective = dataset;
                break;
            }
            case NOTHING: {
                effective = null;
                break;
            }
            default: {
                effective = dataset;
            }
        }
        for (TestStep testStep : testSteps) {
            returnList.addAll(testStep.createExecutionSteps(effective, null, null));
        }
        return returnList;
    }
}

