/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import java.util.Date;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;

@NamedQueries(value={@NamedQuery(name="TestAutomationServer.findByUrlAndLogin", query="from TestAutomationServer where baseURL = :url and login = :login"), @NamedQuery(name="testAutomationServer.findAllHostedProjects", query="select p from TestAutomationProject p join p.server s where s.id = :serverId"), @NamedQuery(name="testAutomationServer.hasBoundProjects", query="select count(*) from TestAutomationProject where server.id = :serverId"), @NamedQuery(name="testAutomationServer.dereferenceProjects", query="update GenericProject set testAutomationServer = null where testAutomationServer.id = :serverId"), @NamedQuery(name="testAutomationServer.deleteServer", query="delete from TestAutomationServer serv where serv.id = :serverId")})
@Entity
@Auditable
@PrimaryKeyJoinColumn(name="SERVER_ID")
public class TestAutomationServer
extends ThirdPartyServer
implements Identified,
AuditableMixin {
    private static final TestAutomationServerKind DEFAULT_KIND = TestAutomationServerKind.jenkins;
    @Column
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TestAutomationServerKind kind;
    @Column(name="MANUAL_SLAVE_SELECTION")
    private boolean manualSlaveSelection;
    @Column(name="DESCRIPTION")
    private String description;
    @Transient
    public AuditableSupport audit;

    public TestAutomationServer() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.kind = DEFAULT_KIND;
        this.manualSlaveSelection = false;
        this.description = "";
    }

    public TestAutomationServerKind getKind() {
        return this.kind;
    }

    public TestAutomationServer(TestAutomationServerKind kind) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.kind = DEFAULT_KIND;
        this.manualSlaveSelection = false;
        this.description = "";
        this.kind = kind;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TestAutomationServer{");
        sb.append("id=").append(this.getId());
        sb.append(", name='").append(this.getName()).append('\'');
        sb.append(", url='").append(this.getUrl()).append('\'');
        sb.append(", kind='").append((Object)this.kind).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean isManualSlaveSelection() {
        return this.manualSlaveSelection;
    }

    public void setManualSlaveSelection(boolean manualSlaveSelection) {
        this.manualSlaveSelection = manualSlaveSelection;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TestAutomationServer createCopy() {
        TestAutomationServer testAutomationServerCopy = new TestAutomationServer(this.getKind());
        testAutomationServerCopy.setName(this.getName());
        testAutomationServerCopy.setUrl(this.getUrl());
        testAutomationServerCopy.setDescription(this.getDescription());
        testAutomationServerCopy.setManualSlaveSelection(this.isManualSlaveSelection());
        return testAutomationServerCopy;
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

