/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.domain.search.AdvancedSearchFieldModel;
import org.squashtest.tm.domain.search.AdvancedSearchFieldModelType;

public class AdvancedSearchNumericRangeFieldModel
implements AdvancedSearchFieldModel {
    private AdvancedSearchFieldModelType type;
    private String minValue;
    private String maxValue;

    public AdvancedSearchNumericRangeFieldModel() {
        this.type = AdvancedSearchFieldModelType.NUMERIC_RANGE;
    }

    public AdvancedSearchNumericRangeFieldModel(AdvancedSearchFieldModelType type) {
        this.type = type;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    @JsonIgnore
    public double getLocaleAgnosticMinValue() {
        try {
            return this.getLocaleAgnosticValue(this.minValue);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    @JsonIgnore
    public double getLocaleAgnosticMaxValue() {
        try {
            return this.getLocaleAgnosticValue(this.maxValue);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.POSITIVE_INFINITY;
        }
    }

    @JsonIgnore
    public boolean hasMinValue() {
        return !StringUtils.isBlank((CharSequence)this.minValue);
    }

    @JsonIgnore
    public boolean hasMaxValue() {
        return !StringUtils.isBlank((CharSequence)this.maxValue);
    }

    private double getLocaleAgnosticValue(String opinionatedValue) {
        Locale locale = LocaleContextHolder.getLocale();
        NumberFormat.getInstance(locale);
        double asDouble = Double.parseDouble(opinionatedValue);
        return asDouble;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public AdvancedSearchFieldModelType getType() {
        return this.type;
    }

    @Override
    public boolean isSet() {
        return this.hasMaxValue() || this.hasMinValue();
    }
}

