/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.search;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.search.AdvancedSearchFieldModel;
import org.squashtest.tm.domain.search.AdvancedSearchSingleFieldModel;

public class AdvancedSearchModel {
    private static final String SEARCH_BY_MILESTONE = "searchByMilestone";
    private static final Set<String> MILESTONE_SEARCH_CRITERIA_KEYS = Sets.newHashSet((Object[])new String[]{"searchByMilestone", "milestone.label", "milestone.status", "milestone.endDate"});
    private Map<String, AdvancedSearchFieldModel> fields = new HashMap<String, AdvancedSearchFieldModel>();

    public AdvancedSearchModel() {
    }

    AdvancedSearchModel(Map<String, AdvancedSearchFieldModel> entries) {
        this.fields = entries;
    }

    public void addField(String fieldName, AdvancedSearchFieldModel value) {
        this.fields.put(fieldName, value);
    }

    public Map<String, AdvancedSearchFieldModel> getFields() {
        if (this.searchByMilestone()) {
            return this.stripSearchByMilestoneField();
        }
        return this.stripMilestones();
    }

    public Set<String> getFieldKeys() {
        return new HashSet<String>(this.getFields().keySet());
    }

    public AdvancedSearchModel shallowCopy() {
        HashMap<String, AdvancedSearchFieldModel> copyfields = new HashMap<String, AdvancedSearchFieldModel>(this.fields);
        return new AdvancedSearchModel(copyfields);
    }

    private boolean searchByMilestone() {
        AdvancedSearchFieldModel byMilestone = this.fields.get(SEARCH_BY_MILESTONE);
        if (byMilestone != null) {
            AdvancedSearchSingleFieldModel milestoneField = (AdvancedSearchSingleFieldModel)byMilestone;
            return milestoneField.getValue().equals("true");
        }
        return false;
    }

    private Map<String, AdvancedSearchFieldModel> stripMilestones() {
        HashMap<String, AdvancedSearchFieldModel> copy = new HashMap<String, AdvancedSearchFieldModel>(this.fields);
        MILESTONE_SEARCH_CRITERIA_KEYS.forEach(copy::remove);
        return copy;
    }

    private Map<String, AdvancedSearchFieldModel> stripSearchByMilestoneField() {
        HashMap<String, AdvancedSearchFieldModel> copy = new HashMap<String, AdvancedSearchFieldModel>(this.fields);
        copy.remove(SEARCH_BY_MILESTONE);
        return copy;
    }
}

