/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.util.Arrays;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.requirement.LinkedRequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;

@Entity
@Table(name="REQUIREMENT_VERSION_LINK")
public class RequirementVersionLink
implements Identified,
RelatedToAuditable {
    @Id
    @Column(name="LINK_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="requirement_version_link_link_id_seq")
    @SequenceGenerator(name="requirement_version_link_link_id_seq", sequenceName="requirement_version_link_link_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="REQUIREMENT_VERSION_ID", referencedColumnName="RES_ID")
    private RequirementVersion requirementVersion;
    @ManyToOne
    @JoinColumn(name="RELATED_REQUIREMENT_VERSION_ID", referencedColumnName="RES_ID")
    private RequirementVersion relatedRequirementVersion;
    @ManyToOne
    @JoinColumn(name="LINK_TYPE_ID", referencedColumnName="TYPE_ID")
    private RequirementVersionLinkType linkType;
    @Column(name="LINK_DIRECTION")
    private boolean linkDirection;

    public RequirementVersionLink() {
    }

    public RequirementVersionLink(RequirementVersion requirementVersion, RequirementVersion relatedRequirementVersion) {
        this.requirementVersion = requirementVersion;
        this.relatedRequirementVersion = relatedRequirementVersion;
    }

    public RequirementVersionLink(RequirementVersion requirementVersion, RequirementVersion relatedRequirementVersion, RequirementVersionLinkType linkType, boolean linkDirection) {
        this.requirementVersion = requirementVersion;
        this.relatedRequirementVersion = relatedRequirementVersion;
        this.linkType = linkType;
        this.linkDirection = linkDirection;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    private String getRequirementVersionRole() {
        if (!this.linkDirection) {
            return this.linkType.getRole1();
        }
        return this.linkType.getRole2();
    }

    private String getRelatedRequirementVersionRole() {
        if (this.linkDirection) {
            return this.linkType.getRole1();
        }
        return this.linkType.getRole2();
    }

    public LinkedRequirementVersion getLinkedRequirementVersion() {
        return new LinkedRequirementVersion(this.requirementVersion, this.getRequirementVersionRole());
    }

    public LinkedRequirementVersion getRelatedLinkedRequirementVersion() {
        return new LinkedRequirementVersion(this.relatedRequirementVersion, this.getRelatedRequirementVersionRole());
    }

    public RequirementVersionLinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(RequirementVersionLinkType linkType) {
        this.linkType = linkType;
    }

    public boolean getLinkDirection() {
        return this.linkDirection;
    }

    public void setLinkDirection(boolean linkDirection) {
        this.linkDirection = linkDirection;
    }

    public RequirementVersionLink createSymmetricalRequirementVersionLink() {
        return new RequirementVersionLink(this.relatedRequirementVersion, this.requirementVersion, this.linkType, !this.linkDirection);
    }

    public RequirementVersionLink copyForRequirementVersion(RequirementVersion copyVersion) {
        return new RequirementVersionLink(copyVersion, this.relatedRequirementVersion, this.linkType, this.linkDirection);
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return Arrays.asList(this.requirementVersion, this.relatedRequirementVersion);
    }
}

