/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import org.hibernate.annotations.Where;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryPluginBinding;

@Entity
public class RequirementLibrary
extends GenericLibrary<RequirementLibraryNode> {
    public static final String CLASS_NAME = "org.squashtest.tm.domain.requirement.RequirementLibrary";
    private static final String SIMPLE_CLASS_NAME = "RequirementLibrary";
    @Id
    @Column(name="RL_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="requirement_library_rl_id_seq")
    @SequenceGenerator(name="requirement_library_rl_id_seq", sequenceName="requirement_library_rl_id_seq", allocationSize=1)
    private Long id;
    @OneToMany
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="REQUIREMENT_LIBRARY_CONTENT", joinColumns={@JoinColumn(name="LIBRARY_ID")}, inverseJoinColumns={@JoinColumn(name="CONTENT_ID")})
    private List<RequirementLibraryNode> rootContent = new ArrayList<RequirementLibraryNode>();
    @OneToOne(mappedBy="requirementLibrary")
    private GenericProject project;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="LIBRARY_ID")
    @Where(clause="LIBRARY_TYPE = 'R'")
    private Set<RequirementLibraryPluginBinding> enabledPlugins = new HashSet<RequirementLibraryPluginBinding>(5);

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public List<RequirementLibraryNode> getContent() {
        return this.rootContent;
    }

    public List<RequirementLibraryNode> getRootContent() {
        return this.rootContent;
    }

    @Override
    public GenericProject getProject() {
        return this.project;
    }

    @Override
    public void notifyAssociatedWithProject(GenericProject p) {
        this.project = p;
    }

    @Override
    public void removeContent(RequirementLibraryNode node) {
        this.rootContent.remove(node);
        this.rootContent = new ArrayList<RequirementLibraryNode>(this.rootContent);
    }

    @Override
    public Set<String> getEnabledPlugins() {
        HashSet<String> pluginIds = new HashSet<String>(this.enabledPlugins.size());
        for (RequirementLibraryPluginBinding binding : this.enabledPlugins) {
            pluginIds.add(binding.getPluginId());
        }
        return pluginIds;
    }

    public Set<RequirementLibraryPluginBinding> getAllPluginBindings() {
        return this.enabledPlugins;
    }

    @Override
    public void enablePlugin(String pluginId) {
        if (!this.isPluginEnabled(pluginId)) {
            RequirementLibraryPluginBinding newBinding = new RequirementLibraryPluginBinding(pluginId);
            this.enabledPlugins.add(newBinding);
        }
    }

    @Override
    public void disablePlugin(String pluginId) {
        RequirementLibraryPluginBinding binding = this.getPluginBinding(pluginId);
        if (binding != null) {
            this.enabledPlugins.remove(binding);
        }
    }

    public RequirementLibraryPluginBinding getPluginBinding(String pluginId) {
        for (RequirementLibraryPluginBinding binding : this.enabledPlugins) {
            if (!binding.getPluginId().equals(pluginId)) continue;
            return binding;
        }
        return null;
    }

    @Override
    public boolean isPluginEnabled(String pluginId) {
        return this.getPluginBinding(pluginId) != null;
    }

    @Override
    public String getClassSimpleName() {
        return SIMPLE_CLASS_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public boolean hasContent() {
        return !this.rootContent.isEmpty();
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Collection<RequirementLibraryNode> getOrderedContent() {
        return this.rootContent;
    }

    @Override
    public boolean allowContentWithIdenticalName() {
        return true;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.REQUIREMENT_LIBRARY, this.getId());
    }
}

