/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.requirement.ForbiddenHighLevelLinkException;

@Entity
@PrimaryKeyJoinColumn(name="RLN_ID")
public class HighLevelRequirement
extends Requirement {
    protected HighLevelRequirement() {
    }

    public HighLevelRequirement(@NotNull RequirementVersion version) {
        super(version);
    }

    @Override
    public boolean isHighLevel() {
        return true;
    }

    @Override
    public void setHighLevelRequirement(HighLevelRequirement highLevelRequirement) {
        throw new ForbiddenHighLevelLinkException();
    }

    @Override
    public HighLevelRequirement createCopy() {
        HighLevelRequirement copy = new HighLevelRequirement();
        copy.notifyAssociatedWithProject((Project)this.getProject());
        RequirementVersion latestVersionCopy = this.getCurrentVersion().createPastableCopy(copy);
        copy.addVersion(latestVersionCopy);
        copy.resource = latestVersionCopy;
        return copy;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

