/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.infolist;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.validation.constraint.HasDefaultItem;
import org.squashtest.tm.validation.constraint.UniqueItems;

@Entity
@Auditable
public class InfoList
implements Identified,
AuditableMixin {
    @Id
    @Column(name="INFO_LIST_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="info_list_info_list_id_seq")
    @SequenceGenerator(name="info_list_info_list_id_seq", sequenceName="info_list_info_list_id_seq", allocationSize=1)
    private Long id;
    @Size(max=100)
    @NotBlank
    private @Size(max=100) @NotBlank String label;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Size(max=30)
    @NotBlank
    private @Size(max=30) @NotBlank String code;
    @Valid
    @UniqueItems
    @HasDefaultItem(value="isDefault")
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="ITEM_INDEX")
    @JoinColumn(name="LIST_ID")
    private List<InfoListItem> items;
    @Transient
    public AuditableSupport audit;

    public InfoList() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.label = "";
        this.items = new ArrayList<InfoListItem>();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public List<InfoListItem> getItems() {
        return this.items;
    }

    public InfoListItem getItem(InfoListItem item) {
        for (InfoListItem thisitem : this.items) {
            if (!item.references(thisitem)) continue;
            return thisitem;
        }
        return null;
    }

    public InfoListItem getItem(String code) {
        for (InfoListItem thisitem : this.items) {
            if (!thisitem.getCode().equals(code)) continue;
            return thisitem;
        }
        return null;
    }

    public void addItem(InfoListItem item) {
        this.items.add(item);
    }

    public void removeItem(InfoListItem item) {
        this.removeItem(item.getCode());
    }

    public void removeItem(Long itemId) {
        Iterator<InfoListItem> iter = this.items.iterator();
        while (iter.hasNext()) {
            if (!itemId.equals(iter.next().getId())) continue;
            iter.remove();
            return;
        }
    }

    public void removeItem(String code) {
        Iterator<InfoListItem> iter = this.items.iterator();
        while (iter.hasNext()) {
            if (!code.equals(iter.next().getCode())) continue;
            iter.remove();
            return;
        }
    }

    public InfoListItem getDefaultItem() {
        for (InfoListItem it : this.items) {
            if (!it.isDefault()) continue;
            return it;
        }
        throw new IllegalStateException("No default item was defined for this list");
    }

    public boolean contains(InfoListItem item) {
        for (InfoListItem it : this.items) {
            if (!it.references(item)) continue;
            return true;
        }
        return false;
    }

    public void addItems(int newIndex, List<InfoListItem> addedItems) {
        this.items.addAll(newIndex, addedItems);
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

