/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringEscapeUtils;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Type;
import org.springframework.context.MessageSource;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Auditable
public class ExecutionStep
implements AttachmentHolder,
IssueDetector,
TestStepVisitor,
Identified,
HasExecutionStatus,
DenormalizedFieldHolder,
BoundEntity,
AuditableMixin {
    public static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    private static final String PARAM_PREFIX = "\\Q${\\E";
    private static final String PARAM_SUFFIX = "\\Q}\\E";
    private static final String PARAM_PATTERN = "\\Q${\\E([A-Za-z0-9_-]{1,255})\\Q}\\E";
    private static final String KEYWORD_PARAM_PATTERN = "<([A-Za-z0-9_-]{1,255})>";
    private static final String NO_PARAM = "&lt;no_value&gt;";
    private static final String KEYWORD_DOCSTRING_MARKER = "\"\"\"";
    private static final String KEYWORD_COMMENT_MARKER = "#";
    @Id
    @Column(name="EXECUTION_STEP_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="execution_step_execution_step_id_seq")
    @SequenceGenerator(name="execution_step_execution_step_id_seq", sequenceName="execution_step_execution_step_id_seq", allocationSize=1)
    private Long id;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Basic(optional=false)
    private String action;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String expectedResult;
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String comment;
    @Column(insertable=false)
    private String lastExecutedBy;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastExecutedOn;
    @ManyToOne
    @JoinColumn(name="TEST_STEP_ID")
    private TestStep referencedTestStep;
    @ManyToOne
    @JoinTable(name="EXECUTION_EXECUTION_STEPS", joinColumns={@JoinColumn(name="EXECUTION_STEP_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="EXECUTION_ID", insertable=false, updatable=false)})
    private Execution execution;
    @Formula(value="(select EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER from  EXECUTION_EXECUTION_STEPS where  EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID = EXECUTION_STEP_ID)")
    private Integer executionStepOrder;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ISSUE_LIST_ID")
    private IssueList issueList;
    @Transient
    private Map<String, String> dataset;
    @Transient
    private MessageSource messageSource;
    @Transient
    private Locale locale;
    @Transient
    public AuditableSupport audit;

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.SETTLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public ExecutionStep() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionStatus = ExecutionStatus.READY;
        this.attachmentList = new AttachmentList();
        this.issueList = new IssueList();
        this.dataset = new HashMap<String, String>();
    }

    public ExecutionStep(ActionTestStep testStep) {
        this(testStep, null);
    }

    public ExecutionStep(ActionTestStep testStep, Dataset dataset) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionStatus = ExecutionStatus.READY;
        this.attachmentList = new AttachmentList();
        this.issueList = new IssueList();
        this.dataset = new HashMap<String, String>();
        this.fillParameterMapPrivately(dataset);
        testStep.accept(this);
        this.referencedTestStep = testStep;
        for (Attachment actionStepAttach : testStep.getAllAttachments()) {
            Attachment clone = actionStepAttach.shallowCopy();
            this.attachmentList.addAttachment(clone);
        }
    }

    public ExecutionStep(KeywordTestStep keywordTestStep) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionStatus = ExecutionStatus.READY;
        this.attachmentList = new AttachmentList();
        this.issueList = new IssueList();
        this.dataset = new HashMap<String, String>();
        this.action = String.valueOf(keywordTestStep.getKeyword().toString()) + " " + keywordTestStep.getActionWord().createWord();
        this.addKeywordStepDetails(keywordTestStep);
        this.referencedTestStep = keywordTestStep;
    }

    public ExecutionStep(KeywordTestStep keywordTestStep, Dataset dataset, MessageSource messageSource, Locale locale) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionStatus = ExecutionStatus.READY;
        this.attachmentList = new AttachmentList();
        this.issueList = new IssueList();
        this.dataset = new HashMap<String, String>();
        this.messageSource = messageSource;
        this.locale = locale;
        this.fillParameterMapPrivately(dataset);
        keywordTestStep.accept(this);
        this.referencedTestStep = keywordTestStep;
    }

    public void fillParameterMap(Dataset dataset) {
        this.fillParameterMapPrivately(dataset);
    }

    private void fillParameterMapPrivately(Dataset dataset) {
        if (dataset != null) {
            for (DatasetParamValue param : dataset.getParameterValues()) {
                String key = param.getParameter().getName();
                String value = param.getParamValue();
                this.dataset.put(key, value);
            }
        }
    }

    public TestStep getReferencedTestStep() {
        return this.referencedTestStep;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public Integer getExecutionStepOrder() {
        return this.executionStepOrder;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        return LEGAL_EXEC_STATUS;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isFirst() {
        return this.executionStepOrder == 0;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getIssueListId() {
        return this.issueList.getId();
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.execution.getCampaignLibrary();
    }

    @Override
    public Project getProject() {
        return this.execution.getProject();
    }

    @Override
    public IssueList getIssueList() {
        return this.issueList;
    }

    @Override
    public void detachIssue(Long id) {
        this.issueList.removeIssue(id);
    }

    @Override
    public void visit(ActionTestStep visited) {
        String originalAction = visited.getAction();
        String originalExpectedResult = visited.getExpectedResult();
        this.action = this.valueParams(originalAction, PARAM_PATTERN);
        this.expectedResult = this.valueParams(originalExpectedResult, PARAM_PATTERN);
    }

    private String valueParams(String content, String patternStr) {
        String result = null;
        if (content != null) {
            StringBuilder builder = new StringBuilder(content);
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(content);
            int offset = 0;
            while (matcher.find()) {
                String paramName = matcher.group(1);
                String paramValue = this.dataset.get(paramName);
                if (paramValue == null || paramValue.isEmpty()) {
                    paramValue = NO_PARAM;
                }
                int start = matcher.start();
                int end = matcher.end();
                builder.replace(start + offset, end + offset, paramValue);
                offset += paramValue.length() - (end - start);
            }
            result = builder.toString();
        }
        return result;
    }

    @Override
    public void visit(CallTestStep visited) {
        this.action = visited.getCalledTestCase().getName();
    }

    @Override
    public void visit(KeywordTestStep keywordStep) {
        String awWordScript = keywordStep.writeTestStepActionWordScript(true);
        String unescapedAWWordScript = StringEscapeUtils.unescapeHtml4((String)awWordScript);
        String replacedParamValueWord = this.valueParams(unescapedAWWordScript, KEYWORD_PARAM_PATTERN);
        Keyword keyword = keywordStep.getKeyword();
        if (this.messageSource != null && this.locale != null) {
            String internationalizedKeyword = this.messageSource.getMessage(keyword.i18nKeywordNameKey(), null, this.locale);
            this.action = String.valueOf(internationalizedKeyword) + " " + replacedParamValueWord;
        } else {
            this.action = String.valueOf(keyword.getLabel()) + " " + replacedParamValueWord;
        }
        this.addKeywordStepDetails(keywordStep);
    }

    private void addKeywordStepDetails(KeywordTestStep keywordStep) {
        this.addKeywordStepDatatable(keywordStep.getDatatable());
        this.addKeywordStepDocstring(keywordStep.getDocstring());
        this.addKeywordStepComment(keywordStep.getComment());
    }

    private void addKeywordStepDatatable(String keywordStepDatatable) {
        if (keywordStepDatatable != null && !keywordStepDatatable.isEmpty()) {
            String datatable = "<br/>" + keywordStepDatatable.replaceAll("\n", "<br/>");
            this.action = String.valueOf(this.action) + datatable;
        }
    }

    private void addKeywordStepDocstring(String keywordStepDocstring) {
        if (keywordStepDocstring != null && !keywordStepDocstring.isEmpty()) {
            String docstring = "<br/>\"\"\"</br>" + keywordStepDocstring.replaceAll("\n", "<br/>");
            this.action = String.valueOf(this.action) + docstring + "<br/>" + KEYWORD_DOCSTRING_MARKER;
        }
    }

    private void addKeywordStepComment(String keywordStepComment) {
        if (keywordStepComment != null && !keywordStepComment.isEmpty()) {
            String comment = "<br/>#" + keywordStepComment.replaceAll("\n", "<br/>#");
            this.action = String.valueOf(this.action) + comment;
        }
    }

    @Override
    public List<Long> getAllIssueListId() {
        LinkedList<Long> ids = new LinkedList<Long>();
        ids.add(this.issueList.getId());
        return ids;
    }

    @Override
    public TestCase getReferencedTestCase() {
        return this.execution.getReferencedTestCase();
    }

    @Override
    public BugTracker getBugTracker() {
        return this.getProject().findBugTracker();
    }

    @Override
    public Long getDenormalizedFieldHolderId() {
        return this.getId();
    }

    @Override
    public DenormalizedFieldHolderType getDenormalizedFieldHolderType() {
        return DenormalizedFieldHolderType.EXECUTION_STEP;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.EXECUTION_STEP;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.EXECUTION_STEP, this.getId());
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

