/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.event;

import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.event.AbstractRequirementPropertyChangeEventBuilder;
import org.squashtest.tm.domain.event.ChangedProperty;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.event.RequirementAuditEventVisitor;
import org.squashtest.tm.domain.event.RequirementPropertyChangeEventBuilder;
import org.squashtest.tm.domain.event.RequirementVersionModification;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.requirement.RequirementVersion;

@Entity
@PrimaryKeyJoinColumn(name="EVENT_ID")
public class RequirementPropertyChange
extends RequirementAuditEvent
implements RequirementVersionModification,
ChangedProperty {
    @NotNull
    @Size(max=100)
    private @NotNull @Size(max=100) String propertyName;
    @Size(max=255)
    private @Size(max=255) String oldValue;
    @Size(max=255)
    private @Size(max=255) String newValue;

    public RequirementPropertyChange() {
    }

    private RequirementPropertyChange(RequirementVersion requirementVersion, String author) {
        super(requirementVersion, author);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getOldValue() {
        return this.oldValue;
    }

    @Override
    public String getNewValue() {
        return this.newValue;
    }

    @Override
    public void accept(RequirementAuditEventVisitor visitor) {
        visitor.visit(this);
    }

    public static RequirementPropertyChangeEventBuilder<RequirementPropertyChange> builder() {
        return new Builder();
    }

    /* synthetic */ RequirementPropertyChange(RequirementVersion requirementVersion, String string, RequirementPropertyChange requirementPropertyChange) {
        this(requirementVersion, string);
    }

    private static class Builder
    extends AbstractRequirementPropertyChangeEventBuilder<RequirementPropertyChange> {
        private Builder() {
        }

        @Override
        public RequirementPropertyChange build() {
            RequirementPropertyChange event = new RequirementPropertyChange(this.eventSource, this.author, null);
            event.propertyName = this.modifiedProperty;
            event.oldValue = this.valueToString(this.oldValue);
            event.newValue = this.valueToString(this.newValue);
            return event;
        }

        private String valueToString(Object value) {
            if (value != null && value instanceof InfoListItem) {
                return ((InfoListItem)value).getLabel();
            }
            return Objects.toString(value, "");
        }
    }
}

