/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.event;

import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.event.AbstractRequirementEventPublisher;
import org.squashtest.tm.domain.event.RequirementCreation;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;

@Aspect
public class RequirementCreationEventPublisherAspect
extends AbstractRequirementEventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementCreationEventPublisherAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ RequirementCreationEventPublisherAspect ajc$perSingletonInstance;

    static {
        try {
            RequirementCreationEventPublisherAspect.ajc$perSingletonInstance = new RequirementCreationEventPublisherAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(public void javax.persistence.EntityManager+.persist(Object)) && args(requirement)")
    private /* synthetic */ void callRequirementPersister(Requirement requirement) {
    }

    @Pointcut(value="execution(public void javax.persistence.EntityManager+.persist(Object)) && args(requirementVersion)")
    private /* synthetic */ void callRequirementVersionPersister(RequirementVersion requirementVersion) {
    }

    @After(value="callRequirementPersister(requirement)")
    public void listenRequirementCreation(Requirement requirement) {
        if (this.aspectIsEnabled()) {
            RequirementCreation event = new RequirementCreation(requirement.getCurrentVersion(), this.currentUser());
            this.publish(event);
            LOGGER.trace("Creation event raised for current version");
        }
    }

    @After(value="callRequirementVersionPersister(requirementVersion)")
    public void listenRequirementVersionCreation(RequirementVersion requirementVersion) {
        if (this.aspectIsEnabled()) {
            RequirementCreation event = new RequirementCreation(requirementVersion, this.currentUser());
            this.publish(event);
            LOGGER.trace("Creation event raised for version");
        }
    }

    public static RequirementCreationEventPublisherAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.squashtest.tm.domain.event.RequirementCreationEventPublisherAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

